/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.task.util.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestStringUtil {
    private static String[] elems = new String[]{"b", "i", "font", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "span", "em", "p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "cite", "blockquote"};
    private static String[] emptyElems = new String[]{"br"};
    private static List<String> tables = Arrays.asList("table", "tr", "td", "th", "colgroup", "thead", "tbody", "tfoot");
    private static String[] disallowElem = new String[]{"script", "iframe", "link", "test"};
    private static String[] allowAttrs = new String[]{"style=\"color:red\""};
    private static String[] disallowAttrs = new String[]{"onmouseover=\"alert('click')\"", "onmouseout=\"alert('click')\""};
    private static List<String> allAttrs = new LinkedList<String>();

    @Test
    public void testCommon() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, elems, allAttrs, true);
        this.buildTag(input, emptyElems, allAttrs, false);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, elems, Arrays.asList(allowAttrs), true);
        this.buildTag(output, emptyElems, Arrays.asList(allowAttrs), false);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testLinks() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, new String[]{"a"}, Arrays.asList("href=\"abcd\""), true);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, new String[]{"a"}, Arrays.asList("href=\"abcd\"", "rel=\"nofollow\""), true);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
        input = new StringBuilder();
        this.buildTag(input, new String[]{"a"}, Arrays.asList("style=\"color:red\"", "href=\"javascript:test\""), true);
        output = new StringBuilder();
        this.buildTag(output, new String[]{"a"}, Arrays.asList("style=\"color:red\""), true);
        encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testImages() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, new String[]{"img"}, Arrays.asList("src=\"abcd\"", "width=\"1\"", "onerror=\"test\""), false);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, new String[]{"img"}, Arrays.asList("src=\"abcd\"", "width=\"1\""), false);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testParseAttribute() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, new String[]{"img"}, Arrays.asList("src=\"jav  ascript:alert('XSS');\"", "width=\"1\"", "onerror=\"test\""), false);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, new String[]{"img"}, Arrays.asList("width=\"1\""), false);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testEncodedAttribute() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, new String[]{"img"}, Arrays.asList("SRC=&#x6A&#x61&#x76&#x61&#x73&#x63&#x72&#x69&#x70&#x74&#x3A&#x61&#x6C&#x65&#x72&#x74&#x28&#x27&#x58&#x53&#x53&#x27&#x29", "width=\"1\""), false);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, new String[]{"img"}, Arrays.asList("width=\"1\""), false);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testTables() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, tables.toArray(new String[tables.size()]), Arrays.asList("align=\"abcd\"", "onmouseover=\"1\""), true);
        StringBuilder output = new StringBuilder();
        this.buildTag(output, tables.toArray(new String[tables.size()]), Arrays.asList("align=\"abcd\""), true);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)output.toString(), (Object)encoded);
    }

    @Test
    public void testDisallowElem() {
        StringBuilder input = new StringBuilder();
        this.buildTag(input, disallowElem, Collections.emptyList(), true);
        String encoded = StringUtil.encodeInjectedHtmlTag((String)input.toString());
        Assert.assertEquals((Object)"abcdabcd", (Object)encoded);
    }

    private void buildTag(StringBuilder builder, String[] elems, List<String> attrs, boolean hasCloseTag) {
        for (String elem : elems) {
            builder.append("<").append(elem).append(" ");
            for (String att : attrs) {
                builder.append(att).append(" ");
            }
            if (attrs.size() > 0) {
                builder.deleteCharAt(builder.length() - 1);
            }
            if (hasCloseTag) {
                builder.append(">");
                if (!tables.contains(elem)) {
                    builder.append("abcd");
                }
                builder.append("</").append(elem).append(">");
                continue;
            }
            builder.append(" />");
        }
    }

    static {
        allAttrs.addAll(Arrays.asList(allowAttrs));
        allAttrs.addAll(Arrays.asList(disallowAttrs));
    }
}

