package org.exoplatform.task.service;

import java.util.List;

import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;

public interface LabelService {
  List<LabelDto> findLabelsByUser(String username, int offset, int limit);

  List<LabelDto> findLabelsByProject(long projectId, Identity currentUser, int offset, int limit);

  List<LabelDto> findLabelsByTask(TaskDto task, long projectId, Identity currentUser, int offset, int limit);

  LabelDto getLabel(long labelId);

  LabelDto createLabel(LabelDto label);

  @ExoTransactional
  LabelDto updateLabel(LabelDto label, List<Label.FIELDS> fields) throws EntityNotFoundException;

  LabelDto updateLabel(LabelDto label) throws EntityNotFoundException;

  void removeLabel(long labelId);

  void addTaskToLabel(TaskDto task, Long labelId) throws EntityNotFoundException;

  void removeTaskFromLabel(TaskDto task, Long labelId) throws EntityNotFoundException;
}
