/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;

public class TestDtoUtils {
    private static Connection conn;
    private static Liquibase liquibase;
    public static long EXISTING_TASK_ID;
    public static long UNEXISTING_TASK_ID;
    public static long EXISTING_PROJECT_ID;
    public static long UNEXISTING_PROJECT_ID;
    public static long EXISTING_STATUS_ID;
    public static long UNEXISTING_STATUS_ID;
    public static long EXISTING_COMMENT_ID;
    public static long UNEXISTING_COMMENT_ID;

    public static void initH2DB() throws SQLException, ClassNotFoundException, LiquibaseException {
        Class.forName("org.h2.Driver");
        conn = DriverManager.getConnection("jdbc:h2:target/h2-db", "sa", "");
        TestDtoUtils.initDB();
    }

    public static void initHSQLDB() throws LiquibaseException, SQLException, ClassNotFoundException {
        Class.forName("org.hsqldb.jdbcDriver");
        conn = DriverManager.getConnection("jdbc:hsqldb:file:target/hsql-db", "sa", "");
        TestDtoUtils.initDB();
    }

    private static void initDB() throws LiquibaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
        liquibase = new Liquibase("db/changelog/task.db.changelog-1.0.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-1.1.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-1.3.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-2.1.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-3.0.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-3.1.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
        liquibase = new Liquibase("db/changelog/task.db.changelog-3.2.0.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update((String)null);
    }

    public static void closeDB() throws LiquibaseException, SQLException {
        liquibase.rollback(1000, null);
        conn.close();
    }

    public static TaskDto getDefaultTask() {
        return TestDtoUtils.getDefaultTaskWithId(EXISTING_TASK_ID);
    }

    public static TaskDto getDefaultTaskWithId(long id) {
        TaskDto task = new TaskDto();
        task.setId(id);
        task.setTitle("Default task");
        task.setAssignee("root");
        task.setCreatedBy("root");
        task.setPriority(Priority.NORMAL);
        task.setCreatedTime(new Date());
        HashSet coworker = new HashSet();
        task.setCoworker(coworker);
        return task;
    }

    public static CommentDto getDefaultComment() {
        CommentDto comment = new CommentDto();
        comment.setId(EXISTING_COMMENT_ID);
        comment.setComment("Bla bla");
        comment.setAuthor("Tib");
        comment.setCreatedTime(new Date());
        return comment;
    }

    public static StatusDto getDefaultStatus() {
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(EXISTING_STATUS_ID));
        status.setName("TODO");
        status.setRank(Integer.valueOf(1));
        return status;
    }

    public static ProjectDto getDefaultProject() {
        ProjectDto project = new ProjectDto();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        project.setLastModifiedDate(Long.valueOf(System.currentTimeMillis()));
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        project.setParticipator(participator);
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }

    public static ProjectDto getParentProject() {
        ProjectDto project = new ProjectDto();
        project.setId(EXISTING_PROJECT_ID);
        project.setName("Default project");
        project.setDescription("The default project");
        project.setDueDate(new Date());
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        project.setParticipator(participator);
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project.setManager(managers);
        return project;
    }

    static {
        EXISTING_TASK_ID = 1L;
        UNEXISTING_TASK_ID = 2L;
        EXISTING_PROJECT_ID = 1L;
        UNEXISTING_PROJECT_ID = 2L;
        EXISTING_STATUS_ID = 1L;
        UNEXISTING_STATUS_ID = 2L;
        EXISTING_COMMENT_ID = 1L;
        UNEXISTING_COMMENT_ID = 2L;
    }
}

