/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.TestUtils;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.model.User;
import org.exoplatform.task.rest.ProjectRestService;
import org.exoplatform.task.rest.TaskRestService;
import org.exoplatform.task.rest.model.PaginatedTaskList;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestProjectRestService {
    @Mock
    TaskService taskService;
    @Mock
    ProjectService projectService;
    @Mock
    ProjectStorage projectStorage;
    @Mock
    StatusService statusService;
    @Mock
    StatusStorage statusStorage;
    @Mock
    UserService userService;
    @Mock
    SpaceService spaceService;
    @Mock
    CommentService commentService;
    @Mock
    LabelService labelService;
    @Mock
    IdentityManager identityManager;

    @Before
    public void setup() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    @Test
    public void testGetTasks() throws Exception {
        TaskRestService taskRestService = new TaskRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        TaskDto task1 = new TaskDto();
        TaskDto task2 = new TaskDto();
        TaskDto task3 = new TaskDto();
        TaskDto task4 = new TaskDto();
        ArrayList<TaskDto> uncompletedTasks = new ArrayList<TaskDto>();
        task1.setCompleted(true);
        uncompletedTasks.add(task2);
        uncompletedTasks.add(task3);
        uncompletedTasks.add(task4);
        ArrayList<TaskDto> overdueTasks = new ArrayList<TaskDto>();
        overdueTasks.add(task1);
        overdueTasks.add(task2);
        ArrayList<TaskDto> incomingTasks = new ArrayList<TaskDto>();
        incomingTasks.add(task1);
        incomingTasks.add(task2);
        Mockito.when((Object)this.taskService.getUncompletedTasks("root", 20)).thenReturn(uncompletedTasks);
        Mockito.when((Object)this.taskService.countUncompletedTasks("root")).thenReturn((Object)uncompletedTasks.size());
        Mockito.when((Object)this.taskService.getOverdueTasks("root", 20)).thenReturn(overdueTasks);
        Mockito.when((Object)this.taskService.countOverdueTasks("root")).thenReturn((Object)overdueTasks.size());
        Mockito.when((Object)this.taskService.getIncomingTasks("root", 0, 20)).thenReturn(incomingTasks);
        Mockito.when((Object)this.taskService.countIncomingTasks("root")).thenReturn((Object)incomingTasks.size());
        Mockito.when((Object)this.taskService.countTasks((String)ArgumentMatchers.eq((Object)"root"), (String)ArgumentMatchers.eq((Object)"searchTerm"))).thenReturn((Object)1L);
        Response response = taskRestService.getTasks("overdue", null, 0, 20, false, false);
        Response response1 = taskRestService.getTasks("incoming", null, 0, 20, false, false);
        Response response2 = taskRestService.getTasks("", null, 0, 20, false, false);
        Response response3 = taskRestService.getTasks("whatever", "searchTerm", 0, 20, true, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        PaginatedTaskList tasks = (PaginatedTaskList)response.getEntity();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        PaginatedTaskList tasks1 = (PaginatedTaskList)response1.getEntity();
        Assert.assertNotNull((Object)tasks1);
        Assert.assertEquals((long)2L, (long)tasks1.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        PaginatedTaskList tasks2 = (PaginatedTaskList)response2.getEntity();
        Assert.assertNotNull((Object)tasks2);
        Assert.assertEquals((long)3L, (long)tasks2.getTasksNumber());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void testGetProjects() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        this.projectService.createProject(project1);
        ProjectDto project2 = new ProjectDto();
        project2.setName("project2");
        this.projectService.createProject(project2);
        ProjectDto project3 = new ProjectDto();
        project3.setName("project3");
        this.projectService.createProject(project3);
        Response response = projectRestService.getProjects(null, "", "ALL", -1, -1, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Space space = new Space();
        space.setDisplayName("space1");
        space.setPrettyName("space1");
        space.setGroupId("/spaces/" + space.getPrettyName());
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("space1")).thenReturn((Object)space);
        List<ProjectDto> projects = Arrays.asList(project1, project2);
        List<String> memberships = Arrays.asList("manager:/spaces/space1", "member:/spaces/space1");
        Mockito.when((Object)this.projectService.findProjects(ArgumentMatchers.anyList(), ArgumentMatchers.anyString(), (OrderBy)ArgumentMatchers.any(OrderBy.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(projects);
        Mockito.when((Object)this.projectService.countProjects(memberships, "")).thenReturn((Object)2);
        response = projectRestService.getProjects("", "space1", "ALL", -1, -1, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        JSONObject jsonObject = new JSONObject(response.getEntity().toString());
        String projectNumber = jsonObject.getString("projectNumber");
        Assert.assertEquals((Object)"2", (Object)projectNumber);
    }

    @Test
    public void testGetDefaultStatusByProjectId() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        project.setManager(manager);
        StatusDto status = new StatusDto();
        status.setId(Long.valueOf(1L));
        status.setName("status 1");
        Response response = projectRestService.getDefaultStatusByProjectId(3L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetProjectById() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        ProjectDto project = new ProjectDto();
        project.setId(1L);
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        project.setManager(manager);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)project);
        Response response = projectRestService.getProjectById(1L, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
        Mockito.when((Object)this.projectService.getManager(1L)).thenReturn(new HashSet<String>(Arrays.asList(null, "")));
        Mockito.when((Object)this.projectService.getParticipator(1L)).thenReturn(new HashSet<String>(Arrays.asList(null, "")));
        response = projectRestService.getProjectById(1L, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
    }

    @Test
    public void testCreateProject() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setName("john");
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        this.projectService.createProject(projectDto);
        Mockito.when((Object)this.projectService.createProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        Response response = projectRestService.createProject(projectDto);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        projectDto.setName(null);
        this.projectService.createProject(projectDto);
        Mockito.when((Object)this.projectService.createProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        response = projectRestService.createProject(projectDto);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        projectDto.setName("john");
        projectDto.setSpaceName("space");
        this.projectService.createProject(projectDto);
        Mockito.when((Object)this.projectService.createProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        response = projectRestService.createProject(projectDto);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.projectService.createProject(projectDto);
        Space space = new Space();
        Mockito.when((Object)this.projectService.createProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)ArgumentMatchers.any())).thenReturn((Object)space);
        response = projectRestService.createProject(projectDto);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.projectService.createProject(projectDto);
        space = new Space();
        space.setGroupId("/space");
        Mockito.when((Object)this.projectService.createProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)ArgumentMatchers.any())).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.isMember(space, "john")).thenReturn((Object)true);
        response = projectRestService.createProject(projectDto);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testUpdateProject() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        Identity exo = new Identity("exo");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        HashSet<String> participator = new HashSet<String>();
        participator.add("exo");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        projectDto.setParticipator(participator);
        this.projectService.updateProject(projectDto);
        Mockito.when((Object)this.projectService.updateProject((ProjectDto)ArgumentMatchers.any())).thenReturn((Object)projectDto);
        Response response = projectRestService.updateProject(projectDto.getId(), projectDto);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        projectDto.setName("john");
        this.projectService.updateProject(projectDto);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectDto.getId()))).thenReturn((Object)projectDto);
        response = projectRestService.updateProject(projectDto.getId(), projectDto);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectDto.getId()))).thenReturn((Object)projectDto);
        response = projectRestService.updateProject(projectDto.getId(), projectDto);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetSatusesByProjectId() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        this.projectService.createProject(project1);
        ProjectDto project2 = new ProjectDto();
        project2.setName("project2");
        this.projectService.createProject(project2);
        ProjectDto project3 = new ProjectDto();
        project3.setName("project3");
        this.projectService.createProject(project3);
        StatusDto status1 = new StatusDto(3L, "ToDo", Integer.valueOf(1), project1);
        StatusDto status2 = new StatusDto(4L, "ToDo", Integer.valueOf(2), project1);
        ArrayList<StatusDto> statuses = new ArrayList<StatusDto>();
        statuses.add(status1);
        statuses.add(status2);
        HashSet foo = new HashSet(statuses);
        project1.setStatus(foo);
        HashSet<String> participator = new HashSet<String>();
        participator.add("Tib");
        project1.setParticipator(participator);
        HashSet<String> managers = new HashSet<String>();
        managers.add("Tib");
        project1.setManager(managers);
        HashSet<String> participator1 = new HashSet<String>();
        participator1.add("root");
        project2.setParticipator(participator1);
        HashSet<String> managers1 = new HashSet<String>();
        managers1.add("root");
        project2.setManager(managers1);
        Response response1 = projectRestService.getStatusesByProjectId(project1.getId());
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project1.getId()))).thenReturn((Object)project1);
        Response response2 = projectRestService.getStatusesByProjectId(project1.getId());
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(project2.getId()))).thenReturn((Object)project2);
        Response response3 = projectRestService.getStatusesByProjectId(project2.getId());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        Assert.assertNotNull((Object)response3.getEntity());
    }

    @Test
    public void testfindUsersToMention() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity root = new Identity("root");
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        final User user = TestUtils.getUser();
        ListAccess<User> lists = new ListAccess<User>(){

            public User[] load(int i, int i1) throws Exception, IllegalArgumentException {
                return new User[]{user};
            }

            public int getSize() throws Exception {
                return 1;
            }
        };
        Mockito.when((Object)this.userService.findUserByName("root")).thenReturn((Object)lists);
        Response response = projectRestService.getUsersByQueryAndProjectName("root", "project1");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testFindUsersToMentionInTasksAffectedToProject() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity root = new Identity("root");
        User userA = TestUtils.getUserA();
        org.exoplatform.social.core.identity.model.Identity userAIdentity = TestUtils.getUserAIdentity();
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        HashSet<String> projectParticipator = new HashSet<String>();
        projectParticipator.add(root.getUserId());
        projectParticipator.add(userA.getUsername());
        ProjectDto project1 = new ProjectDto();
        project1.setName("project1");
        project1.setId(1L);
        project1.setParticipator(projectParticipator);
        Response response = projectRestService.getProjectParticipants(1L, "userA", false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertNotNull((Object)response.getEntity());
    }

    @Test
    public void testDeleteProject() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setName("john");
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectDto.getId()))).thenReturn((Object)projectDto);
        Response response1 = projectRestService.deleteProject(Long.valueOf(projectDto.getId()), Boolean.valueOf(false), 0, 0);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
    }

    @Test
    public void testCloneProject() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setName("john");
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        ProjectDto projectCloned = new ProjectDto();
        projectCloned.setId(2L);
        projectCloned.setName("john");
        projectCloned.setDescription("bla bla bla");
        projectCloned.setManager(manager);
        Mockito.when((Object)this.projectService.cloneProject(projectDto.getId(), true)).thenReturn((Object)projectCloned);
        Response response1 = projectRestService.cloneProject(projectDto);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
    }

    @Test
    public void testChangeProjectColor() throws Exception {
        ProjectRestService projectRestService = new ProjectRestService(this.taskService, this.commentService, this.projectService, this.statusService, this.userService, this.spaceService, this.labelService, this.identityManager);
        Identity john = new Identity("john");
        ConversationState.setCurrent((ConversationState)new ConversationState(john));
        HashSet<String> manager = new HashSet<String>();
        manager.add("john");
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setColor("");
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        ProjectDto projectDto1 = new ProjectDto();
        projectDto.setId(1L);
        projectDto.setColor("red");
        projectDto.setDescription("bla bla bla");
        projectDto.setManager(manager);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(projectDto.getId()))).thenReturn((Object)projectDto);
        Response response1 = projectRestService.changeProjectColor(Long.valueOf(projectDto.getId()), "red");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
    }
}

