/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.task.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtil {
    @Test
    public void testFormatDueDate() {
        ResourceBundle rb_en = ResourceBundle.getBundle("locale.portlet.taskManagement", Locale.ENGLISH);
        ResourceBundle rb_fr = ResourceBundle.getBundle("locale.portlet.taskManagement", Locale.FRENCH);
        Calendar now = Calendar.getInstance();
        String enResult = DateUtil.formatDueDate((Calendar)now, (ResourceBundle)rb_en);
        String frResult = DateUtil.formatDueDate((Calendar)now, (ResourceBundle)rb_fr);
        Assert.assertEquals((Object)enResult, (Object)rb_en.getString("label.today"));
        Assert.assertEquals((Object)frResult, (Object)rb_fr.getString("label.today"));
        Calendar yesterday = (Calendar)now.clone();
        yesterday.add(5, -1);
        enResult = DateUtil.formatDueDate((Calendar)yesterday, (ResourceBundle)rb_en);
        frResult = DateUtil.formatDueDate((Calendar)yesterday, (ResourceBundle)rb_fr);
        Assert.assertEquals((Object)enResult, (Object)rb_en.getString("label.yesterday"));
        Assert.assertEquals((Object)frResult, (Object)rb_fr.getString("label.yesterday"));
        Calendar tomorrow = (Calendar)now.clone();
        tomorrow.add(5, 1);
        enResult = DateUtil.formatDueDate((Calendar)tomorrow, (ResourceBundle)rb_en);
        frResult = DateUtil.formatDueDate((Calendar)tomorrow, (ResourceBundle)rb_fr);
        Assert.assertEquals((Object)enResult, (Object)rb_en.getString("label.tomorrow"));
        Assert.assertEquals((Object)frResult, (Object)rb_fr.getString("label.tomorrow"));
        Calendar firstFebLastYear = (Calendar)now.clone();
        firstFebLastYear.set(5, 1);
        firstFebLastYear.set(2, 1);
        firstFebLastYear.add(1, -1);
        enResult = DateUtil.formatDueDate((Calendar)firstFebLastYear, (ResourceBundle)rb_en);
        frResult = DateUtil.formatDueDate((Calendar)firstFebLastYear, (ResourceBundle)rb_fr);
        DateFormat dfEn = DateFormat.getDateInstance(2, rb_en.getLocale());
        DateFormat dfFr = DateFormat.getDateInstance(2, rb_fr.getLocale());
        Assert.assertEquals((Object)enResult, (Object)dfEn.format(firstFebLastYear.getTime()));
        Assert.assertEquals((Object)frResult, (Object)dfFr.format(firstFebLastYear.getTime()));
    }
}

