/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.NotificationUtils;
import org.exoplatform.task.integration.notification.TaskAssignPlugin;
import org.junit.Assert;
import org.junit.Test;

public class TaskAssignPluginTest {
    @Test
    public void shouldReturnAssigneeInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        task.setAssignee("user1");
        TaskAssignPlugin notificationPlugin = new TaskAssignPlugin(new InitParams());
        Set receivers = notificationPlugin.getReceiver(task, null);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)1L, (long)receivers.size());
        Assert.assertEquals((Object)"user1", receivers.iterator().next());
    }

    @Test
    public void shouldNotReturnAssigneeInReceiversWhenAssigneeIsCreator() throws Exception {
        TaskDto task = new TaskDto();
        task.setAssignee("user1");
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.CREATOR, (Object)"user1");
        TaskAssignPlugin notificationPlugin = new TaskAssignPlugin(new InitParams());
        Set receivers = notificationPlugin.getReceiver(task, ctx);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)0L, (long)receivers.size());
    }
}

