/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.Arrays;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.gamification.GamificationTaskUpdateListener;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class GamificationTaskUpdateListenerTest {
    private static final long TASK_ID = 2L;
    private static final String USERNAME = "test";
    private static final String COWORKER1 = "cotest1";
    private static final String COWORKER2 = "cotest2";
    private static final String COWORKER3 = "cotest3";
    @Mock
    private TaskService taskService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ListenerService listenerService;
    @Mock
    private TaskDto oldTask;
    @Mock
    private TaskDto task;

    @Before
    public void setUp() {
        Mockito.when((Object)this.task.getId()).thenReturn((Object)2L);
        ConversationState.setCurrent((ConversationState)new ConversationState(new Identity(USERNAME)));
    }

    @After
    public void tearDown() {
        ConversationState.setCurrent(null);
    }

    @Test
    public void testCreateTask() throws Exception {
        GamificationTaskUpdateListener gamificationTaskUpdateListener = new GamificationTaskUpdateListener(this.taskService, this.identityManager, this.listenerService);
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(USERNAME)).thenReturn((Object)userIdentity);
        Event event = new Event("exo.task.taskCreation", null, (Object)new TaskPayload(null, this.task));
        gamificationTaskUpdateListener.onEvent(event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("createNewTask"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
    }

    @Test
    public void testUpdateTask() throws Exception {
        this.mockIdentity("1", USERNAME);
        this.mockIdentity("2", COWORKER1);
        this.mockIdentity("3", COWORKER2);
        this.mockIdentity("4", COWORKER3);
        Mockito.when((Object)this.taskService.getTaskLogs(ArgumentMatchers.eq((long)2L), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(Arrays.asList(this.newChangeLogEntry("assign", USERNAME), this.newChangeLogEntry("assignCoworker", COWORKER1), this.newChangeLogEntry("assignCoworker", COWORKER2), this.newChangeLogEntry("assignCoworker", COWORKER3)));
        new GamificationTaskUpdateListener(this.taskService, this.identityManager, this.listenerService).onEvent(new Event("exo.task.taskUpdate", null, (Object)new TaskPayload(this.oldTask, this.task)));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("updateTask"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTask"))), (Object)ArgumentMatchers.eq((long)2L));
        Mockito.when((Object)this.task.isCompleted()).thenReturn((Object)true);
        new GamificationTaskUpdateListener(this.taskService, this.identityManager, this.listenerService).onEvent(new Event("exo.task.taskUpdate", null, (Object)new TaskPayload(this.oldTask, this.task)));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("updateTask"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTaskAssigned"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)3))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTaskCoworker"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTaskCoworker") && ((String)source.get("senderId")).equals("2"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTaskCoworker") && ((String)source.get("senderId")).equals("3"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("completeTaskCoworker") && ((String)source.get("senderId")).equals("4"))), (Object)((String)ArgumentMatchers.eq((Object)"2")));
    }

    private ChangeLogEntry newChangeLogEntry(String logName, String target) {
        ChangeLogEntry changeLogEntry = new ChangeLogEntry();
        changeLogEntry.setTarget(target);
        changeLogEntry.setActionName(logName);
        return changeLogEntry;
    }

    private void mockIdentity(String identityId, String username) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)identityId);
        Mockito.when((Object)userIdentity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)userIdentity);
    }
}

