/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.HashMap;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskCommentListener
extends Listener<TaskService, CommentDto> {
    private static final String GAMIFICATION_TASK_ADDON_COMMENT_TASK = "commentTask";
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationTaskCommentListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TaskService, CommentDto> event) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        TaskDto task = ((CommentDto)event.getData()).getTask();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        HashMap<String, String> gam = new HashMap<String, String>();
        gam.put("eventId", GAMIFICATION_TASK_ADDON_COMMENT_TASK);
        gam.put("objectId", String.valueOf(task.getId()));
        gam.put("objectType", "task");
        gam.put("senderId", actorId);
        gam.put("receiverId", actorId);
        String gamificationEventName = event.getEventName().equals("exo.task.taskCommentDeletion") ? "gamification.delete.event.action" : "exo.gamification.generic.action";
        this.listenerService.broadcast(gamificationEventName, gam, (Object)String.valueOf(task.getId()));
    }
}

