/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskUpdateListener
extends Listener<TaskService, TaskPayload> {
    private static final Log LOG = ExoLogger.getLogger(GamificationTaskUpdateListener.class);
    public static final String GAMIFICATION_TASK_ADDON_CREATE_TASK = "createNewTask";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK_ASSIGNED = "completeTaskAssigned";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK_COWORKER = "completeTaskCoworker";
    public static final String GAMIFICATION_TASK_ADDON_COMPLETED_TASK = "completeTask";
    public static final String GAMIFICATION_TASK_ADDON_UPDATE_TASK = "updateTask";
    protected TaskService taskService;
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationTaskUpdateListener(TaskService taskService, IdentityManager identityManager, ListenerService listenerService) {
        this.taskService = taskService;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        TaskDto oldTask = data.before();
        TaskDto newTask = data.after();
        switch (event.getEventName()) {
            case "exo.task.taskCreation": 
            case "exo.task.taskDeleted": {
                this.createTask(newTask, event.getEventName());
                break;
            }
            case "exo.task.taskUpdate": {
                this.updateTask(oldTask, newTask, event.getEventName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
            }
        }
    }

    protected void createTask(TaskDto task, String eventName) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        Map<String, String> gam = this.buildGamificationEventDetails(GAMIFICATION_TASK_ADDON_CREATE_TASK, actorId, actorId, String.valueOf(task.getId()));
        this.listenerService.broadcast(this.getGamificationEventName(eventName), gam, (Object)String.valueOf(task.getId()));
    }

    protected void updateTask(TaskDto before, TaskDto after, String eventName) throws Exception {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        long taskId = after.getId();
        List<ChangeLogEntry> taskLogs = this.taskService.getTaskLogs(taskId, 0, -1);
        if (!before.isCompleted() && after.isCompleted()) {
            this.createGamificationRealization("exo.gamification.generic.action", taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_ASSIGNED, taskLogs, "assign");
            this.createGamificationRealization("exo.gamification.generic.action", taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_COWORKER, taskLogs, "assignCoworker");
            Map<String, String> gam = this.buildGamificationEventDetails(GAMIFICATION_TASK_ADDON_COMPLETED_TASK, actorId, actorId, String.valueOf(taskId));
            this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)String.valueOf(taskId));
        } else if (before.isCompleted() && !after.isCompleted()) {
            this.createGamificationRealization("gamification.cancel.event.action", taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_ASSIGNED, taskLogs, "assign");
            this.createGamificationRealization("gamification.cancel.event.action", taskId, GAMIFICATION_TASK_ADDON_COMPLETED_TASK_COWORKER, taskLogs, "assignCoworker");
            Map<String, String> gam = this.buildGamificationEventDetails(GAMIFICATION_TASK_ADDON_COMPLETED_TASK, actorId, actorId, String.valueOf(taskId));
            this.listenerService.broadcast("gamification.cancel.event.action", gam, (Object)String.valueOf(taskId));
        } else {
            Map<String, String> gam = this.buildGamificationEventDetails(GAMIFICATION_TASK_ADDON_UPDATE_TASK, actorId, actorId, String.valueOf(taskId));
            this.listenerService.broadcast(this.getGamificationEventName(eventName), gam, (Object)String.valueOf(taskId));
        }
    }

    private void createGamificationRealization(String gamificationEventName, long taskId, String eventName, List<ChangeLogEntry> taskLogs, String taskLogName) {
        Set<String> usernames = taskLogs.stream().filter(taskLog -> StringUtils.equals((CharSequence)taskLogName, (CharSequence)taskLog.getActionName())).map(ChangeLogEntry::getTarget).collect(Collectors.toSet());
        this.createGamificationRealization(gamificationEventName, taskId, usernames, eventName);
    }

    private void createGamificationRealization(String gamificationEventName, long taskId, Set<String> usernames, String eventName) {
        usernames.forEach(username -> {
            Identity identity = this.identityManager.getOrCreateUserIdentity(username);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                return;
            }
            Map<String, String> gam = this.buildGamificationEventDetails(eventName, identity.getId(), identity.getId(), String.valueOf(taskId));
            try {
                this.listenerService.broadcast(gamificationEventName, gam, (Object)String.valueOf(taskId));
            }
            catch (Exception e) {
                LOG.warn("An error occurred while broadcasting event {}", new Object[]{eventName, e});
            }
        });
    }

    private String getGamificationEventName(String eventName) {
        if (eventName.equals("exo.task.taskDeleted")) {
            return "gamification.delete.event.action";
        }
        return "exo.gamification.generic.action";
    }

    private Map<String, String> buildGamificationEventDetails(String gamificationEventName, String earnerId, String receiverId, String objectId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        gam.put("eventId", gamificationEventName);
        gam.put("objectId", objectId);
        gam.put("objectType", "task");
        gam.put("senderId", earnerId);
        gam.put("receiverId", receiverId);
        return gam;
    }
}

