/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.notification;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.integration.notification.AbstractNotificationPlugin;
import org.exoplatform.task.util.ProjectUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractNotificationPluginTest {
    @Mock
    private OrganizationService organizationService;
    private MockedStatic<CommonsUtils> commonsUtils;
    private MockedStatic<ProjectUtil> projectUtil;

    @Before
    public void setUp() throws Exception {
        this.commonsUtils = Mockito.mockStatic(CommonsUtils.class);
        this.projectUtil = Mockito.mockStatic(ProjectUtil.class);
        this.commonsUtils.when(() -> CommonsUtils.getOrganizationService()).thenReturn((Object)this.organizationService);
    }

    @After
    public void tearDown() throws Exception {
        this.commonsUtils.close();
        this.projectUtil.close();
    }

    @Test
    public void shouldReturnAssigneeInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        task.setAssignee("user1");
        ProjectDto projectDto = new ProjectDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setProject(new ProjectDto());
        task.setStatus(statusDto);
        DummyNotificationPlugin notificationPlugin = new DummyNotificationPlugin(new InitParams());
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user1", (ProjectDto)projectDto)).thenReturn((Object)true);
        Set receivers = notificationPlugin.getReceiver(task, null);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)1L, (long)receivers.size());
        Assert.assertEquals((Object)"user1", receivers.iterator().next());
    }

    @Test
    public void shouldReturnCoworkersInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        ProjectDto projectDto = new ProjectDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setProject(new ProjectDto());
        task.setStatus(statusDto);
        task.setCoworker(new HashSet<String>(Arrays.asList("user1", "user2")));
        DummyNotificationPlugin notificationPlugin = new DummyNotificationPlugin(new InitParams());
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user1", (ProjectDto)projectDto)).thenReturn((Object)true);
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user2", (ProjectDto)projectDto)).thenReturn((Object)true);
        Set receivers = notificationPlugin.getReceiver(task, null);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)2L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("user1"));
        Assert.assertTrue((boolean)receivers.contains("user2"));
    }

    @Test
    public void shouldReturnWatchersInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        ProjectDto projectDto = new ProjectDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setProject(new ProjectDto());
        task.setStatus(statusDto);
        task.setWatcher(new HashSet<String>(Arrays.asList("user1", "user2")));
        DummyNotificationPlugin notificationPlugin = new DummyNotificationPlugin(new InitParams());
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user1", (ProjectDto)projectDto)).thenReturn((Object)true);
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user2", (ProjectDto)projectDto)).thenReturn((Object)true);
        Set receivers = notificationPlugin.getReceiver(task, null);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)2L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("user1"));
        Assert.assertTrue((boolean)receivers.contains("user2"));
    }

    @Test
    public void shouldReturnCreatorInReceivers() throws Exception {
        TaskDto task = new TaskDto();
        task.setAssignee("user1");
        task.setCreatedBy("user2");
        ProjectDto projectDto = new ProjectDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setProject(new ProjectDto());
        task.setStatus(statusDto);
        task.setCoworker(new HashSet<String>(Arrays.asList("user2", "user3")));
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        DummyNotificationPlugin notificationPlugin = new DummyNotificationPlugin(new InitParams());
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user1", (ProjectDto)projectDto)).thenReturn((Object)true);
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user2", (ProjectDto)projectDto)).thenReturn((Object)true);
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user3", (ProjectDto)projectDto)).thenReturn((Object)true);
        Set receivers = notificationPlugin.getReceiver(task, ctx);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)3L, (long)receivers.size());
        Assert.assertTrue((boolean)receivers.contains("user1"));
        Assert.assertTrue((boolean)receivers.contains("user2"));
        Assert.assertTrue((boolean)receivers.contains("user3"));
    }

    @Test
    public void shouldNotReturnUserInReceiversIfNotProjectParticipant() throws Exception {
        TaskDto task = new TaskDto();
        task.setCreatedBy("user2");
        task.setAssignee("user1");
        ProjectDto projectDto = new ProjectDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setProject(new ProjectDto());
        task.setStatus(statusDto);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        DummyNotificationPlugin notificationPlugin = new DummyNotificationPlugin(new InitParams());
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user1", (ProjectDto)projectDto)).thenReturn((Object)false);
        this.projectUtil.when(() -> ProjectUtil.isProjectParticipant((OrganizationService)this.organizationService, (String)"user2", (ProjectDto)projectDto)).thenReturn((Object)true);
        Set receivers = notificationPlugin.getReceiver(task, ctx);
        Assert.assertNotNull((Object)receivers);
        Assert.assertEquals((long)1L, (long)receivers.size());
        Assert.assertFalse((boolean)receivers.contains("user1"));
        Assert.assertTrue((boolean)receivers.contains("user2"));
    }

    public class DummyNotificationPlugin
    extends AbstractNotificationPlugin {
        public DummyNotificationPlugin(InitParams initParams) {
            super(initParams);
        }

        public String getId() {
            return "DummyNotificationPlugin";
        }

        public boolean isValid(NotificationContext notificationContext) {
            return true;
        }
    }
}

