/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dto.ChangeLogEntry;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.LabelDto;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.dto.TasksList;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.User;
import org.exoplatform.task.rest.model.CommentEntity;
import org.exoplatform.task.rest.model.FiltreTaskList;
import org.exoplatform.task.rest.model.PaginatedTaskList;
import org.exoplatform.task.rest.model.SpaceEntity;
import org.exoplatform.task.rest.model.TaskEntity;
import org.exoplatform.task.rest.model.ViewState;
import org.exoplatform.task.service.CommentService;
import org.exoplatform.task.service.LabelService;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.storage.CommentStorage;
import org.exoplatform.task.util.CommentUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.task.util.UserUtil;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/tasks")
@Tag(name="/tasks", description="Managing tasks")
@RolesAllowed(value={"users"})
public class TaskRestService
implements ResourceContainer {
    private static final int DEFAULT_LIMIT = 20;
    private static final Log LOG = ExoLogger.getLogger(TaskRestService.class);
    private TaskService taskService;
    private CommentService commentService;
    private ProjectService projectService;
    private StatusService statusService;
    private UserService userService;
    private SpaceService spaceService;
    private LabelService labelService;
    private CommentStorage commentStorage;
    private static final String PERCENT_ENCODED_REGEX = "%(?![0-9a-fA-F]{2})";

    public TaskRestService(TaskService taskService, CommentService commentService, ProjectService projectService, StatusService statusService, UserService userService, SpaceService spaceService, LabelService labelService) {
        this.taskService = taskService;
        this.commentService = commentService;
        this.projectService = projectService;
        this.statusService = statusService;
        this.userService = userService;
        this.spaceService = spaceService;
        this.labelService = labelService;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Get task by id", method="GET", description="This get the task if the authenticated user has permissions to view the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getTaskById(@Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.ok((Object)task).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Task By Id {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets uncompleted tasks of the authenticated user", method="GET", description="This returns uncompleted tasks of the authenticated user in the following cases: <br/><ul><li>The authenticated is the creator of the task</li><li>The authenticated is the assignee of the task</li><li>The authenticated is a coworker of the task</li></ul>")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getTasks(@Parameter(description="Type of task to get (all, incoming, overdue)") @QueryParam(value="status") String status, @Parameter(description="Search term") @QueryParam(value="q") String query, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of tasks or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Returning All Details") @Schema(defaultValue="false") @QueryParam(value="returnDetails") boolean returnDetails) {
        try {
            long tasksSize;
            Identity currentId = ConversationState.getCurrent().getIdentity();
            String currentUser = currentId.getUserId();
            LinkedList<String> memberships = new LinkedList<String>();
            memberships.addAll(UserUtil.getMemberships(currentId));
            List<TaskDto> tasks = null;
            if (StringUtils.isBlank((CharSequence)query)) {
                TaskType taskType;
                try {
                    taskType = TaskType.valueOf(status.toUpperCase());
                }
                catch (Exception e) {
                    taskType = TaskType.ALL;
                }
                if (limit <= 0) {
                    limit = 20;
                }
                switch (taskType) {
                    case INCOMING: {
                        tasks = this.taskService.getIncomingTasks(currentUser, offset, limit);
                        tasksSize = this.taskService.countIncomingTasks(currentUser);
                        break;
                    }
                    case OVERDUE: {
                        tasks = this.taskService.getOverdueTasks(currentUser, limit);
                        tasksSize = this.taskService.countOverdueTasks(currentUser);
                        break;
                    }
                    case WATCHED: {
                        tasks = this.taskService.getWatchedTasks(currentUser, limit);
                        tasksSize = this.taskService.countWatchedTasks(currentUser);
                        break;
                    }
                    case COLLABORATED: {
                        tasks = this.taskService.getCollaboratedTasks(currentUser, limit);
                        tasksSize = this.taskService.countCollaboratedTasks(currentUser);
                        break;
                    }
                    case ASSIGNED: {
                        tasks = this.taskService.getAssignedTasks(currentUser, limit);
                        tasksSize = this.taskService.countAssignedTasks(currentUser);
                        break;
                    }
                    default: {
                        tasks = this.taskService.getUncompletedTasks(currentUser, limit);
                        tasksSize = this.taskService.countUncompletedTasks(currentUser);
                        break;
                    }
                }
            } else {
                tasks = this.taskService.findTasksByMemberShips(currentUser, memberships, query, limit);
                tasksSize = this.taskService.countTasks(currentUser, query);
            }
            return Response.ok((Object)new PaginatedTaskList(tasks.stream().map(task -> this.getTaskDetails((TaskDto)task, currentId)).collect(Collectors.toList()), tasksSize)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't Gets uncompleted tasks of the authenticated user", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="filter")
    @Produces(value={"application/json"})
    @Operation(summary="Gets  a specific task", method="GET", description="This returns  a specific task")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request ful"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response filterTasks(@Parameter(description="Type of task to get (all, incoming, overdue)") @QueryParam(value="statusDto") String status, @Parameter(description="projectId term") @Schema(defaultValue="-2") @QueryParam(value="projectId") long projectId, @Parameter(description="Search term") @QueryParam(value="query") String query, @Parameter(description="dueCategory term") @QueryParam(value="dueCategory") String dueCategory, @Parameter(description="priority term") @QueryParam(value="priority") String priority, @Parameter(description="assignee term") @QueryParam(value="assignee") String assignee, @Parameter(description="coworker term") @QueryParam(value="coworker") String coworker, @Parameter(description="watchers term") @QueryParam(value="watcher") String watcher, @Parameter(description="showCompletedTasks term") @Schema(defaultValue="false") @QueryParam(value="showCompletedTasks") boolean showCompletedTasks, @Parameter(description="statusId term") @QueryParam(value="statusId") String statusId, @Parameter(description="space_group_id term") @QueryParam(value="space_group_id") String space_group_id, @Parameter(description="groupBy term") @QueryParam(value="groupBy") String groupBy, @Parameter(description="orderBy term") @QueryParam(value="orderBy") String orderBy, @Parameter(description="dueDate term") @QueryParam(value="dueDate") String dueDate, @Parameter(description="labelId term") @QueryParam(value="labelId") Long labelId, @Parameter(description="filterLabelIds term") @QueryParam(value="filterLabelIds") String filterLabelIds, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of tasks or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Returning All Details") @Schema(defaultValue="false") @QueryParam(value="returnDetails") boolean returnDetails) {
        try {
            LabelDto label;
            String listId = ViewState.buildId(projectId, labelId, dueCategory);
            Identity currIdentity = ConversationState.getCurrent().getIdentity();
            if (assignee != null && assignee.equals("ME")) {
                assignee = currIdentity.getUserId();
            }
            if (coworker != null && coworker.equals("ME")) {
                coworker = currIdentity.getUserId();
            }
            if (watcher != null && watcher.equals("ME")) {
                watcher = currIdentity.getUserId();
            }
            Long statusIdLong = null;
            if (StringUtils.isNotBlank((CharSequence)statusId)) {
                StatusDto statusDto = this.statusService.getStatus(Long.parseLong(statusId));
                if (statusDto == null || !statusDto.getProject().canView(currIdentity)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                statusIdLong = statusDto.getId();
            }
            ViewState.Filter filter = new ViewState.Filter(listId);
            filter.updateFilterData(filterLabelIds, statusId, dueDate, priority, assignee, coworker, watcher, showCompletedTasks, query);
            ProjectDto project = null;
            boolean noProjPermission = false;
            boolean advanceSearch = true;
            if (projectId > 0L && !(project = this.projectService.getProject(projectId)).canView(currIdentity)) {
                if (advanceSearch) {
                    noProjPermission = true;
                } else {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            boolean noLblPermission = false;
            if (labelId != null && labelId > 0L && !(label = this.labelService.getLabel(labelId)).getUsername().equals(currIdentity.getUserId())) {
                if (advanceSearch) {
                    noLblPermission = true;
                } else {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
            }
            String currentUser = currIdentity.getUserId();
            TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
            if (currentUser == null || currentUser.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            TasksList tasks = this.taskService.filterTasks(query, projectId, filter.getKeyword(), filter.getLabel(), filter.getDue(), filter.getPriority(), filter.getAssignees(), filter.getCoworkers(), filter.getWatchers(), labelId, statusIdLong, currIdentity, dueCategory, space_group_id, userTimezone, filter.isShowCompleted(), advanceSearch, noProjPermission, noLblPermission, orderBy, groupBy, offset, limit);
            HashMap<GroupKey, List<TaskEntity>> groupTasks = new HashMap();
            if (groupBy != null && groupBy != "dueDate" && !groupBy.isEmpty() && !"none".equalsIgnoreCase(groupBy)) {
                groupTasks = TaskUtil.groupTasks(tasks.getListTasks().stream().map(task -> this.getTaskDetails((TaskDto)task, currIdentity)).collect(Collectors.toList()), groupBy, currIdentity, userTimezone, this.labelService, this.userService);
                return Response.ok((Object)new FiltreTaskList(groupTasks)).build();
            }
            return Response.ok((Object)new PaginatedTaskList(tasks.getListTasks().stream().map(task -> this.getTaskDetails((TaskDto)task, currIdentity)).collect(Collectors.toList()), tasks.getTasksSize())).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't filter Tasks", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="project/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets tasks by projectIdr", method="GET", description="This returns list of tasks by project")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getTasksByProjectId(@Parameter(description="Id", required=true) @Schema(defaultValue="0") @PathParam(value="id") Long id, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="0") @QueryParam(value="limit") int limit, @Parameter(description="Returning the Completed tasks") @Schema(defaultValue="false") @QueryParam(value="completed") boolean completed, @Parameter(description="Returning the number of tasks or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Returning All Details") @Schema(defaultValue="false") @QueryParam(value="returnDetails") boolean returnDetails) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(id);
            if (project == null || !project.canView(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            List<TaskDto> tasks = null;
            TaskQuery taskQuery = new TaskQuery();
            ArrayList<Long> allProjectIds = new ArrayList<Long>();
            allProjectIds.add(id);
            if (limit == 0) {
                limit = -1;
            }
            taskQuery.setProjectIds(allProjectIds);
            taskQuery.setCompleted(completed);
            tasks = this.taskService.findTasks(taskQuery, limit, offset);
            if (returnSize) {
                JSONObject tasksSizeJsonObject = new JSONObject();
                if (returnDetails) {
                    tasksSizeJsonObject.put("tasks", (Collection)tasks.stream().map(task -> this.getTaskDetails((TaskDto)task, currentUser)).collect(Collectors.toList()));
                } else {
                    tasksSizeJsonObject.put("tasks", tasks);
                }
                return Response.ok((Object)tasksSizeJsonObject).build();
            }
            if (returnDetails) {
                return Response.ok(tasks.stream().map(task -> this.getTaskDetails((TaskDto)task, currentUser)).collect(Collectors.toList())).build();
            }
            return Response.ok(tasks).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Tasks By ProjectId {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Add a new task", method="POST", description="This adds a new task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response addTask(@RequestBody(description="task object to be updated", required=true) TaskDto task) {
        if (task == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            task.setCreatedBy(identity.getUserId());
            task.setCreatedTime(new Date());
            if (task.getStatus() == null || task.getStatus().getProject() == null) {
                if (task.getAssignee() == null) {
                    task.setAssignee(identity.getUserId());
                }
                task.setStatus(null);
            }
            if (task.getStatus() != null && (task.getStatus().getId() == null || task.getStatus().getId() == 0L) && task.getStatus().getProject() != null) {
                long projectId = task.getStatus().getProject().getId();
                ProjectDto projectDto = this.projectService.getProject(projectId);
                if (projectDto == null) {
                    LOG.warn((Object)"Task's project not found");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                if (!this.projectService.getProject(projectId).canView(identity)) {
                    LOG.warn("User {} attempts to create a task under a non authorized project {}", new Object[]{identity.getUserId(), projectDto.getName()});
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                task.setStatus(this.statusService.getDefaultStatus(projectId));
            }
            task = this.taskService.createTask(task);
            return Response.ok((Object)task).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't add Task", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="clone/{taskId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Clones a specific task by id", method="POST", description="This clones the task if the authenticated user has permissions to edit the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response cloneTask(@Parameter(description="Task id", required=true) @PathParam(value="taskId") long taskId) {
        try {
            TaskDto task = this.taskService.getTask(taskId);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            TaskDto newTask = this.taskService.cloneTask(taskId);
            if (newTask == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)newTask).build();
        }
        catch (Exception e) {
            LOG.error("Can't clone Task {}", new Object[]{taskId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific task by id", method="PUT", description="This updates the task if the authenticated user has permissions to view the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateTaskById(@Parameter(description="Task id", required=true) @PathParam(value="id") long id, @RequestBody(description="task object to be updated", required=true) TaskDto updatedTask) {
        if (updatedTask == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (task.getStatus() == null) {
                task.setStatus(updatedTask.getStatus());
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            task = this.taskService.updateTask(updatedTask);
            return Response.ok((Object)task).build();
        }
        catch (Exception e) {
            LOG.error("Can't update Task {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific task by id", method="PUT", description="This updates the task if the authenticated user has permissions to view the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteTaskById(@Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.taskService.removeTask(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't delete Task {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="labels")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets labels of the authenticated user", method="GET", description="This returns labels of the authenticated user")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getLabels() {
        try {
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            return Response.ok(this.labelService.findLabelsByUser(currentUser, 0, -1)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't get Labels", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="labels/project/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets labels of the given project", method="GET", description="This returns labels of the given project")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response getLabelsByProjectId(@Parameter(description="project id", required=true) @PathParam(value="id") long id) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            ProjectDto project = this.projectService.getProject(id);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!project.canView(currentUser)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            return Response.ok(this.labelService.findLabelsByProject(id, currentUser, 0, -1)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't get Labels", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="labels/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets labels of a specific task by id", method="GET", description="This returns labels of a specific task by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getLabelsByTaskId(@Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            List<Object> labels = new ArrayList();
            if (task.getStatus() != null && task.getStatus().getProject() != null) {
                labels = this.labelService.findLabelsByTask(task, task.getStatus().getProject().getId(), currentUser, 0, -1);
            }
            return Response.ok(labels).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Labels By TaskId {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="labels/{id}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds a specific task by id to a label", method="POST", description="This adds a specific task by id to a label")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response addTaskToLabel(@RequestBody(description="label", required=true) LabelDto addedLabel, @Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            if (addedLabel == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            try {
                ProjectDto project;
                ProjectDto projectDto = project = task.getStatus() == null || task.getStatus().getProject() == null ? null : this.projectService.getProject(task.getStatus().getProject().getId());
                if (project == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (!project.canView(currentUser)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
                addedLabel.setProject(project);
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (addedLabel.getId() == 0L) {
                addedLabel.setUsername(currentUser.getUserId());
                LabelDto label = this.labelService.createLabel(addedLabel);
                this.labelService.addTaskToLabel(task, label.getId());
            } else {
                this.labelService.addTaskToLabel(task, addedLabel.getId());
            }
            return Response.ok((Object)addedLabel).build();
        }
        catch (Exception e) {
            LOG.error("Can't add Task {} To Label", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="labels/{id}/{labelId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Deletes a specific task association to a specific label", method="DELETE", description="This deletes a specific task association to a specific label")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response removeTaskFromLabel(@Parameter(description="label id", required=true) @PathParam(value="labelId") long labelId, @Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            LabelDto label = this.labelService.getLabel(labelId);
            if (label == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.labelService.removeTaskFromLabel(task, labelId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't remove Task {} From Label {}", new Object[]{id, labelId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="labels")
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds a specific task by id to a label", method="POST", description="This adds a specific task by id to a label")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response addLabel(@RequestBody(description="label object to create", required=true) LabelDto addedLabel) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            if (addedLabel == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            try {
                ProjectDto project = this.projectService.getProject(addedLabel.getProject().getId());
                if (project == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (!project.canEdit(currentUser)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (addedLabel.getId() == 0L) {
                addedLabel.setUsername(currentUser.getUserId());
                LabelDto labelDto = this.labelService.createLabel(addedLabel);
            }
            return Response.ok((Object)addedLabel).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't add  Label", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="labels/{labelId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds a specific task by id to a label", method="POST", description="This adds a specific task by id to a label")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response editLabel(@Parameter(description="label id", required=true) @PathParam(value="labelId") long labelId, @RequestBody(description="label object to update", required=true) LabelDto label) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            if (label == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            try {
                ProjectDto project = this.projectService.getProject(label.getProject().getId());
                if (project == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (!project.canEdit(currentUser)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (this.labelService.getLabel(labelId) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            label = this.labelService.updateLabel(label);
            return Response.ok((Object)label).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't add  Label", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="labels/{labelId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Deletes a specific  label", method="DELETE", description="This deletes a specific task association to a specific label")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response removeLabel(@Parameter(description="label id", required=true) @PathParam(value="labelId") long labelId) {
        try {
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            LabelDto label = this.labelService.getLabel(labelId);
            if (label == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            try {
                ProjectDto project = this.projectService.getProject(label.getProject().getId());
                if (project == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                if (!project.canEdit(currentUser)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.labelService.removeLabel(labelId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't remove Label {}", new Object[]{labelId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="logs/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets a logs of a specific task", method="GET", description="This returns a logs of a specific task")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getTaskLogs(@Parameter(description="Task id", required=true) @PathParam(value="id") long id, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="-1") @QueryParam(value="limit") int limit) {
        try {
            List<ChangeLogEntry> arr;
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasViewPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (limit == 0) {
                limit = -1;
            }
            if ((arr = this.taskService.getTaskLogs(id, offset, limit)) == null) {
                return Response.ok(Collections.emptyList()).build();
            }
            LinkedList<ChangeLogEntry> logs = new LinkedList<ChangeLogEntry>(arr);
            return Response.ok(logs).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Task {} Logs", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="comments/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets a comment list of a specific task", method="GET", description="This returns a comment list of a specific task")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getTaskComments(@Parameter(description="Task id", required=true) @PathParam(value="id") long id, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="-1") @QueryParam(value="limit") int limit) {
        try {
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasViewPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (limit == 0) {
                limit = -1;
            }
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            List<CommentDto> comments = this.commentService.getCommentsWithSubs(id, offset, limit);
            ArrayList<CommentEntity> commentModelsList = new ArrayList<CommentEntity>();
            for (CommentDto comment : comments) {
                CommentEntity commentModel = this.addCommentModel(comment, commentModelsList, TaskUtil.getUserLanguage(currentUser));
                if (comment.getSubComments() == null || comment.getSubComments().isEmpty()) continue;
                ArrayList<CommentEntity> subCommentsModelsList = new ArrayList<CommentEntity>();
                for (CommentDto subComment : comment.getSubComments()) {
                    this.addCommentModel(subComment, subCommentsModelsList, TaskUtil.getUserLanguage(currentUser));
                }
                commentModel.setSubComments(subCommentsModelsList);
            }
            Collections.reverse(commentModelsList);
            return Response.ok(commentModelsList).build();
        }
        catch (Exception e) {
            LOG.error("Can't get Task {} Comments", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="comments/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Adds comment to a specific task by id", method="POST", description="This Adds comment to a specific task by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response addTaskComment(@Parameter(description="Comment text", required=false) String commentText, @Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            commentText = commentText.replaceAll(PERCENT_ENCODED_REGEX, "%25");
            commentText = commentText.replaceAll("\\+", "%2b");
            CommentDto addedComment = this.commentService.addComment(task, currentUser, commentText = URLDecoder.decode(commentText, "UTF-8"));
            if (addedComment != null) {
                addedComment = this.commentService.getComment(addedComment.getId());
            }
            CommentEntity commentEntity = new CommentEntity(addedComment, this.userService.loadUser(currentUser), CommentUtil.formatMention(commentText, TaskUtil.getUserLanguage(currentUser)));
            return Response.ok((Object)commentEntity).build();
        }
        catch (Exception e) {
            LOG.error("Can't add Comment to Task {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="comments/{commentId}/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds a sub comment to a specific parent comment by id and a specific task by id", method="POST", description="This Adds sub comment to a parent comment in specific task by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response addTaskSubComment(@Parameter(description="Comment text", required=false) String commentText, @Parameter(description="Comment id", required=true) @PathParam(value="commentId") long commentId, @Parameter(description="Task id", required=true) @PathParam(value="id") long id) {
        try {
            String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
            TaskDto task = this.taskService.getTask(id);
            if (task == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            commentText = commentText.replaceAll(PERCENT_ENCODED_REGEX, "%25");
            commentText = commentText.replaceAll("\\+", "%2b");
            CommentDto addedComment = this.commentService.addComment(task, commentId, currentUser, commentText = URLDecoder.decode(commentText, "UTF-8"));
            if (addedComment != null) {
                addedComment = this.commentService.getComment(addedComment.getId());
            }
            CommentEntity commentEntity = new CommentEntity(addedComment, this.userService.loadUser(currentUser), CommentUtil.formatMention(commentText, TaskUtil.getUserLanguage(currentUser)));
            return Response.ok((Object)commentEntity).build();
        }
        catch (Exception e) {
            LOG.error("Can't add SubComment to Task {}", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="comments/{commentId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific task comment by id", method="DELETE", description="This deletes a specific task comment by id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response deleteComment(@Parameter(description="Comment id", required=true) @PathParam(value="commentId") long commentId) {
        try {
            CommentDto comment = this.commentService.getComment(commentId);
            if (comment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            if (!TaskUtil.canDeleteComment(currentIdentity, comment)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.commentService.removeComment(commentId);
            return Response.ok((Object)comment).build();
        }
        catch (Exception e) {
            LOG.error("Can't delete Comment {}", new Object[]{commentId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="usersToMention/{query}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets users to mention in comment", method="GET", description="This returns users to mention in comment")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public Response findUsersToMention(@Parameter(description="Query", required=true) @PathParam(value="query") String query) {
        try {
            ListAccess<User> list = this.userService.findUserByName(query, true);
            JSONArray usersJsonArray = new JSONArray();
            for (User user : (User[])list.load(0, 10)) {
                JSONObject userJson = new JSONObject();
                Object fullName = user.getDisplayName();
                if (this.taskService.isExternal(user.getUsername())) {
                    fullName = (String)fullName + " (" + TaskUtil.getResourceBundleLabel(new Locale(TaskUtil.getUserLanguage(user.getUsername())), "external.label.tag") + ")";
                }
                userJson.put("id", (Object)("@" + user.getUsername()));
                userJson.put("name", fullName);
                userJson.put("avatar", (Object)user.getAvatar());
                userJson.put("type", (Object)"contact");
                usersJsonArray.put((Object)userJson);
            }
            return Response.ok((Object)usersJsonArray.toString()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Can't findUsersToMention", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="updateCompleted/{idTask}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific task by id", method="PUT", description="This updates the task if the authenticated user has permissions to view the objects linked to this task.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Unauthorized operation"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response updateCompleted(@Parameter(description="Task id", required=true) @PathParam(value="idTask") long idTask, @Parameter(description="isCompleted") @Schema(defaultValue="false") @QueryParam(value="isCompleted") boolean isCompleted) {
        try {
            TaskDto task = this.taskService.getTask(idTask);
            if (!TaskUtil.hasEditPermission(this.taskService, task)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            task.setCompleted(isCompleted);
            this.taskService.updateTask(task);
            return Response.ok((Object)task).build();
        }
        catch (Exception e) {
            LOG.error("Can't set task {} as Completed", new Object[]{idTask, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private CommentEntity addCommentModel(CommentDto comment, List<CommentEntity> commentModelsList, String lang) {
        CommentEntity commentEntity;
        User user = this.userService.loadUser(comment.getAuthor());
        StatusDto taskStatus = comment.getTask().getStatus();
        if (taskStatus != null) {
            comment.getTask().setStatus(taskStatus.clone());
        }
        if ((commentEntity = new CommentEntity(comment, user, CommentUtil.formatMention(comment.getComment(), lang))).getSubComments() == null) {
            commentEntity.setSubComments(new ArrayList<CommentEntity>());
        }
        commentModelsList.add(commentEntity);
        return commentEntity;
    }

    private TaskEntity getTaskDetails(TaskDto task, Identity userIdentity) {
        int commentCount;
        long taskId = task.getId();
        try {
            commentCount = this.commentService.countComments(taskId);
        }
        catch (Exception e) {
            LOG.warn("Error retrieving task '{}' comments count", new Object[]{taskId, e});
            commentCount = 0;
        }
        TaskEntity taskEntity = new TaskEntity(task, commentCount);
        if (task.getStatus() != null && task.getStatus().getProject() != null) {
            ArrayList<LabelDto> labels = new ArrayList();
            try {
                labels = this.labelService.findLabelsByTask(task, task.getStatus().getProject().getId(), userIdentity, 0, -1);
            }
            catch (Exception e) {
                LOG.warn("Error retrieving task '{}' labels", new Object[]{taskId, e});
            }
            SpaceEntity space = this.getProjectSpace(task.getStatus().getProject());
            taskEntity.setLabels(labels);
            taskEntity.setSpace(space);
        }
        return taskEntity;
    }

    private SpaceEntity getProjectSpace(ProjectDto project) {
        for (String permission : this.projectService.getManager(project.getId())) {
            String groupId;
            Space space;
            int index = permission.indexOf(58);
            if (index <= -1 || (space = this.spaceService.getSpaceByGroupId(groupId = permission.substring(index + 1))) == null) continue;
            return new SpaceEntity(space.getId(), space.getDisplayName(), space.getGroupId(), space.getUrl(), space.getPrettyName(), space.getAvatarUrl());
        }
        return null;
    }

    private static enum TaskType {
        ALL,
        INCOMING,
        OVERDUE,
        WATCHED,
        COLLABORATED,
        ASSIGNED;

    }
}

