/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.inject.Inject;
import juzu.HttpMethod;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dao.OrderBy;
import org.exoplatform.task.domain.Comment;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.domain.TaskLog;
import org.exoplatform.task.exception.AbstractEntityException;
import org.exoplatform.task.exception.ProjectNotFoundException;
import org.exoplatform.task.exception.TaskNotFoundException;
import org.exoplatform.task.management.templates.comments;
import org.exoplatform.task.management.templates.detail;
import org.exoplatform.task.management.templates.projectTaskListView;
import org.exoplatform.task.management.templates.taskComments;
import org.exoplatform.task.management.templates.taskLogs;
import org.exoplatform.task.model.CommentModel;
import org.exoplatform.task.model.GroupKey;
import org.exoplatform.task.model.TaskModel;
import org.exoplatform.task.model.User;
import org.exoplatform.task.service.ParserContext;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskParser;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.utils.CommentUtils;
import org.exoplatform.task.utils.DateUtil;
import org.exoplatform.task.utils.ProjectUtil;
import org.exoplatform.task.utils.TaskUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskController {
    private static final Log LOG = ExoLogger.getExoLogger(TaskController.class);
    private static final List<String> VIEW_TYPES = Arrays.asList("list", "board");
    public static final int MIN_NUMBER_TASK_GROUPABLE = 2;
    @Inject
    TaskService taskService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    TaskParser taskParser;
    @Inject
    OrganizationService orgService;
    @Inject
    UserService userService;
    @Inject
    ResourceBundle bundle;
    @Inject
    @Path(value="detail.gtmpl")
    detail detail;
    @Inject
    @Path(value="taskLogs.gtmpl")
    taskLogs taskLogs;
    @Inject
    @Path(value="taskComments.gtmpl")
    taskComments taskComments;
    @Inject
    @Path(value="comments.gtmpl")
    comments comments;
    @Inject
    @Path(value="projectTaskListView.gtmpl")
    projectTaskListView taskListView;

    @Resource
    @Ajax
    @MimeType.HTML
    public Response detail(Long id, SecurityContext securityContext) {
        try {
            TaskModel model = TaskUtil.getTaskModel((Long)id, (boolean)false, (ResourceBundle)this.bundle, (String)securityContext.getRemoteUser(), (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
            TimeZone userTimezone = this.userService.getUserTimezone(securityContext.getRemoteUser());
            return this.detail.with().taskModel((Object)model).userTimezone((Object)userTimezone).bundle((Object)this.bundle).ok().withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (Exception ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response renderTaskLogs(Long taskId, SecurityContext securityContext) throws TaskNotFoundException {
        Task task = this.taskService.getTaskById(taskId.longValue());
        LinkedList logs = new LinkedList(task.getTaskLogs());
        Collections.sort(logs);
        HashMap<String, User> userMap = new HashMap<String, User>();
        if (logs.size() > 0) {
            for (TaskLog log : logs) {
                String author = log.getAuthor();
                if (userMap.containsKey(author)) continue;
                User user = this.userService.loadUser(log.getAuthor());
                userMap.put(author, user);
            }
        }
        return this.taskLogs.with().bundle((Object)this.bundle).taskLogs(logs).userMap(userMap).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response renderTaskComments(Long id, Boolean loadAllComment, SecurityContext securityContext) {
        try {
            if (loadAllComment == null) {
                loadAllComment = Boolean.FALSE;
            }
            TaskModel model = TaskUtil.getTaskModel((Long)id, (boolean)loadAllComment, (ResourceBundle)this.bundle, (String)securityContext.getRemoteUser(), (TaskService)this.taskService, (OrganizationService)this.orgService, (UserService)this.userService, (ProjectService)this.projectService);
            return this.taskComments.with().taskModel((Object)model).bundle((Object)this.bundle).ok().withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (Exception ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response clone(Long id) {
        try {
            Task newTask = this.taskService.cloneTaskById(id.longValue());
            JSONObject json = new JSONObject();
            json.put("id", newTask.getId());
            return Response.ok((CharSequence)json.toString());
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response delete(Long id) {
        try {
            this.taskService.deleteTaskById(id.longValue());
            JSONObject json = new JSONObject();
            json.put("id", (Object)id);
            return Response.ok((CharSequence)json.toString());
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveTaskInfo(Long taskId, String name, String[] value, SecurityContext context) {
        try {
            TimeZone timezone = this.userService.getUserTimezone(context.getRemoteUser());
            Task task = this.taskService.updateTaskInfo(taskId.longValue(), name, value, timezone);
            String response = "Update successfully";
            if ("workPlan".equalsIgnoreCase(name)) {
                Calendar start = DateUtil.newCalendarInstance((TimeZone)timezone);
                start.setTime(task.getStartDate());
                Calendar end = DateUtil.newCalendarInstance((TimeZone)timezone);
                end.setTime(task.getEndDate());
                response = TaskUtil.getWorkPlan((Calendar)start, (Calendar)end, (ResourceBundle)this.bundle);
                if (response == null) {
                    response = this.bundle.getString("label.noWorkPlan");
                }
            }
            return Response.ok((CharSequence)response);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveTaskOrder(Long taskId, Long newStatusId, Long[] orders) {
        if (taskId == null || taskId == 0L) {
            return Response.status((int)404).body((CharSequence)"Task not found");
        }
        Status newStatus = null;
        if (newStatusId != null && newStatusId > 0L) {
            newStatus = this.statusService.getStatusById(newStatusId.longValue());
        }
        long[] ids = new long[orders.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = orders[i];
        }
        this.taskService.updateTaskOrder(taskId.longValue(), newStatus, ids);
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response updateCompleted(Long taskId, Boolean completed) {
        try {
            this.taskService.updateTaskCompleted(taskId.longValue(), completed);
            return Response.ok((CharSequence)"Update successfully");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response comment(Long taskId, String comment, SecurityContext securityContext) {
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null || currentUser.isEmpty()) {
            return Response.status((int)401);
        }
        try {
            Comment cmt = this.taskService.addCommentToTaskId(taskId.longValue(), currentUser, comment);
            CommentModel model = new CommentModel(cmt, this.userService.loadUser(cmt.getAuthor()), CommentUtils.formatMention((String)cmt.getComment(), (UserService)this.userService));
            SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy HH:mm");
            df.setTimeZone(this.userService.getUserTimezone(currentUser));
            JSONObject json = new JSONObject();
            json.put("id", model.getId());
            JSONObject user = new JSONObject();
            user.put("username", (Object)model.getAuthor().getUsername());
            user.put("displayName", (Object)model.getAuthor().getDisplayName());
            user.put("avatar", (Object)model.getAuthor().getAvatar());
            json.put("author", (Object)user);
            json.put("comment", (Object)model.getComment());
            json.put("formattedComment", (Object)model.getFormattedComment());
            json.put("createdTime", model.getCreatedTime().getTime());
            json.put("createdTimeString", (Object)df.format(model.getCreatedTime()));
            return Response.ok((CharSequence)json.toString()).withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)ex.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response loadAllComments(Long taskId, SecurityContext securityContext) {
        try {
            List cmts = this.taskService.getCommentsByTaskId(taskId.longValue(), 0, -1);
            ArrayList<CommentModel> listComments = new ArrayList<CommentModel>(cmts.size());
            for (Comment cmt : cmts) {
                User u = this.userService.loadUser(cmt.getAuthor());
                listComments.add(new CommentModel(cmt, u, CommentUtils.formatMention((String)cmt.getComment(), (UserService)this.userService)));
            }
            User currentUser = this.userService.loadUser(securityContext.getRemoteUser());
            return this.comments.with().commentCount((Object)cmts.size()).comments(listComments).currentUser((Object)currentUser).ok().withCharset(Tools.UTF_8);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response deleteComment(Long commentId) {
        try {
            this.taskService.deleteCommentById(commentId.longValue());
            return Response.ok((CharSequence)"Delete comment successfully!");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response listTasks(String space_group_id, Long projectId, String keyword, String groupBy, String orderBy, String filter, String viewType, SecurityContext securityContext) {
        List tasks;
        Map defOrders;
        Map defGroupBys;
        boolean isBoardView;
        Project project = null;
        if (projectId <= 0L || viewType == null || !VIEW_TYPES.contains(viewType)) {
            viewType = (String)VIEW_TYPES.get(0);
        }
        if (isBoardView = viewType.equals(VIEW_TYPES.get(1))) {
            defGroupBys = TaskUtil.resolve(Arrays.asList("none", "assignee"), (ResourceBundle)this.bundle);
            defOrders = TaskUtil.resolve(Arrays.asList("dueDate", "priority", "rank"), (ResourceBundle)this.bundle);
            if (orderBy == null || !defOrders.containsKey(orderBy)) {
                orderBy = "dueDate";
            }
            if (groupBy == null || !defGroupBys.containsKey(groupBy)) {
                groupBy = "none";
            }
        } else {
            defGroupBys = TaskUtil.getDefGroupBys((long)projectId, (ResourceBundle)this.bundle);
            defOrders = TaskUtil.getDefOrders((ResourceBundle)this.bundle);
        }
        String currentUser = securityContext.getRemoteUser();
        TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
        if (currentUser == null || currentUser.isEmpty()) {
            return Response.status((int)401);
        }
        Identity currIdentity = ConversationState.getCurrent().getIdentity();
        LinkedList<Long> spaceProjectIds = null;
        if (space_group_id != null) {
            spaceProjectIds = new LinkedList<Long>();
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService));
            for (Project p : projects) {
                if (!p.canView(currIdentity)) continue;
                spaceProjectIds.add(p.getId());
            }
        }
        LinkedList<Long> allProjectIds = null;
        if (projectId == 0L) {
            allProjectIds = new LinkedList<Long>();
            List projects = ProjectUtil.flattenTree((List)ProjectUtil.getProjectTree(null, (ProjectService)this.projectService));
            for (Project p : projects) {
                if (!p.canView(currIdentity)) continue;
                allProjectIds.add(p.getId());
            }
        }
        OrderBy.ASC order = null;
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            Object object = order = "title".equals(orderBy) || "dueDate".equals(orderBy) ? new OrderBy.ASC(orderBy) : new OrderBy.DESC(orderBy);
        }
        if (projectId == -1L) {
            if (orderBy == null || orderBy.isEmpty()) {
                orderBy = "createdTime";
                order = new OrderBy.DESC(orderBy);
            }
            tasks = this.taskService.getIncomingTasksByUser(currentUser, (OrderBy)order);
        } else if (projectId == -2L) {
            Calendar c;
            defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project", "dueDate"), (ResourceBundle)this.bundle);
            defOrders = TaskUtil.resolve(Arrays.asList("title", "status", "dueDate", "priority", "rank"), (ResourceBundle)this.bundle);
            Date fromDueDate = null;
            Date toDueDate = null;
            if ("overDue".equalsIgnoreCase(filter)) {
                fromDueDate = null;
                toDueDate = new Date();
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate"), (ResourceBundle)this.bundle);
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "project" : groupBy;
            } else if ("today".equalsIgnoreCase(filter)) {
                c = DateUtil.newCalendarInstance((TimeZone)userTimezone);
                c.set(10, 0);
                c.set(12, 0);
                c.set(13, 0);
                fromDueDate = c.getTime();
                c.add(10, 24);
                toDueDate = c.getTime();
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                if (orderBy == null) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            } else if ("tomorrow".equalsIgnoreCase(filter)) {
                c = DateUtil.newCalendarInstance((TimeZone)userTimezone);
                c.set(10, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.add(10, 24);
                fromDueDate = c.getTime();
                c.add(10, 24);
                toDueDate = c.getTime();
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "rank"), (ResourceBundle)this.bundle);
                if (orderBy == null || !defOrders.containsKey(orderBy)) {
                    order = new OrderBy.DESC("priority");
                    orderBy = "priority";
                }
                groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            } else if ("upcoming".equalsIgnoreCase(filter)) {
                c = DateUtil.newCalendarInstance((TimeZone)userTimezone);
                c.set(10, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.add(5, 2);
                fromDueDate = c.getTime();
                toDueDate = null;
                defGroupBys = TaskUtil.resolve(Arrays.asList("none", "project"), (ResourceBundle)this.bundle);
                defOrders = TaskUtil.resolve(Arrays.asList("title", "priority", "dueDate", "rank"), (ResourceBundle)this.bundle);
                String string = groupBy = groupBy == null || !defGroupBys.containsKey(groupBy) ? "none" : groupBy;
            }
            if (orderBy == null || !defOrders.containsKey(orderBy)) {
                orderBy = "dueDate";
                order = new OrderBy.ASC("dueDate");
            }
            if (groupBy == null || !defGroupBys.containsKey(groupBy)) {
                groupBy = "dueDate";
            }
            tasks = this.taskService.getToDoTasksByUser(currentUser, spaceProjectIds, (OrderBy)order, fromDueDate, toDueDate);
        } else {
            if (projectId == 0L) {
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                tasks = spaceProjectIds != null ? this.projectService.getTasksWithKeywordByProjectId(spaceProjectIds, (OrderBy)order, keyword) : this.projectService.getTasksWithKeywordByProjectId(allProjectIds, (OrderBy)order, keyword);
            } else {
                if (orderBy == null || orderBy.isEmpty()) {
                    orderBy = "dueDate";
                    order = new OrderBy.ASC(orderBy);
                }
                tasks = this.projectService.getTasksWithKeywordByProjectId(Arrays.asList(projectId), (OrderBy)order, keyword);
            }
            if (projectId > 0L) {
                try {
                    project = this.projectService.getProjectById(projectId);
                }
                catch (ProjectNotFoundException e) {
                    return Response.notFound((CharSequence)("not found project " + projectId));
                }
            }
        }
        if (tasks.size() < 2) {
            groupBy = "";
        }
        HashMap<Long, Integer> numberTasks = new HashMap<Long, Integer>();
        if (isBoardView) {
            for (Task task : tasks) {
                Status st = task.getStatus();
                int num = 0;
                if (numberTasks.containsKey(st.getId())) {
                    num = (Integer)numberTasks.get(st.getId());
                }
                numberTasks.put(st.getId(), ++num);
            }
        }
        HashMap<String, User> userMap = null;
        Map groupTasks = new HashMap<GroupKey, List>();
        if (groupBy != null && !groupBy.isEmpty()) {
            TimeZone tz = this.userService.getUserTimezone(currentUser);
            groupTasks = TaskUtil.groupTasks((List)tasks, (String)groupBy, (TimeZone)tz, (ResourceBundle)this.bundle);
            if ("assignee".equalsIgnoreCase(groupBy)) {
                userMap = new HashMap<String, User>();
                for (GroupKey key : groupTasks.keySet()) {
                    String assignee = (String)key.getValue();
                    User user = this.userService.loadUser(assignee);
                    userMap.put(assignee, user);
                }
            }
        }
        if (groupTasks.isEmpty()) {
            groupTasks.put(new GroupKey("", null, 0), tasks);
        }
        long taskNum = 0L;
        taskNum = allProjectIds != null ? TaskUtil.getTaskNum((String)currentUser, allProjectIds, (Long)projectId, (TaskService)this.taskService) : TaskUtil.getTaskNum((String)currentUser, spaceProjectIds, (Long)projectId, (TaskService)this.taskService);
        return this.taskListView.with().orders((Object)defOrders).groups((Object)defGroupBys).currentProjectId((Object)projectId).project((Object)project).tasks((Object)tasks).taskNum((Object)taskNum).groupTasks(groupTasks).keyword((Object)(keyword == null ? "" : keyword)).groupBy((Object)(groupBy == null ? "none" : groupBy)).orderBy((Object)(orderBy == null ? "" : orderBy)).filter((Object)(filter == null ? "" : filter)).bundle((Object)this.bundle).viewType((Object)viewType).userTimezone((Object)userTimezone).set("userMap", userMap).set("numberTasksByStatus", numberTasks).ok().withCharset(Tools.UTF_8);
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.JSON
    public Response createTask(Long projectId, String taskInput, String filter, SecurityContext securityContext) {
        if (taskInput == null || taskInput.isEmpty()) {
            return Response.content((int)406, (CharSequence)"Task input must not be null or empty");
        }
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null || currentUser.isEmpty()) {
            return Response.status((int)401);
        }
        ParserContext context = new ParserContext(this.userService.getUserTimezone(currentUser));
        Task task = this.taskParser.parse(taskInput, context);
        task.setCreatedBy(currentUser);
        if (projectId > 0L) {
            try {
                this.projectService.createTaskToProjectId(projectId.longValue(), task);
            }
            catch (AbstractEntityException e) {
                return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
            }
        } else {
            task.setAssignee(currentUser);
            TimeZone userTimezone = this.userService.getUserTimezone(currentUser);
            Calendar dueDate = DateUtil.newCalendarInstance((TimeZone)userTimezone);
            if ("tomorrow".equalsIgnoreCase(filter)) {
                dueDate.add(5, 1);
            } else if ("upcoming".equalsIgnoreCase(filter)) {
                dueDate.add(5, 7);
            } else if (!"today".equalsIgnoreCase(filter)) {
                dueDate = null;
            }
            if (dueDate != null) {
                task.setDueDate(dueDate.getTime());
            }
            this.taskService.createTask(task);
        }
        long taskNum = -1L;
        if (projectId == -1L) {
            taskNum = TaskUtil.getTaskNum((String)currentUser, null, (Long)projectId, (TaskService)this.taskService);
        }
        try {
            JSONObject json = new JSONObject();
            json.put("id", task.getId());
            json.put("taskNum", taskNum);
            return Response.ok((CharSequence)json.toString());
        }
        catch (JSONException ex) {
            return Response.status((int)500).body((CharSequence)("JSONException: " + (Object)((Object)ex)));
        }
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response createTaskInListView(String taskTitle, Long projectId, Long statusId, String assignee, String viewType, String groupBy, String orderBy, SecurityContext securityContext) {
        Status status;
        if (taskTitle == null || taskTitle.isEmpty()) {
            return Response.status((int)406).body((CharSequence)"Task title is required");
        }
        Task task = new Task();
        task.setTitle(taskTitle);
        if (assignee != null && !assignee.isEmpty()) {
            task.setAssignee(assignee);
        }
        if (statusId != null) {
            Status status2 = this.statusService.getStatusById(statusId.longValue());
            if (status2 != null) {
                task.setStatus(status2);
            }
        } else if (projectId != null && (status = this.statusService.findLowestRankStatusByProject(projectId.longValue())) != null) {
            task.setStatus(status);
        }
        this.taskService.createTask(task);
        return this.listTasks(null, projectId, null, groupBy, orderBy, null, viewType, securityContext);
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.HTML
    public Response removeStatus(Long statusId, SecurityContext securityContext) {
        try {
            Status status = this.statusService.getStatusById(statusId.longValue());
            Project project = status.getProject();
            if (project.getStatus().size() > 1) {
                this.statusService.deleteStatus(statusId.longValue());
                return this.listTasks(null, Long.valueOf(project.getId()), null, null, null, null, "board", securityContext);
            }
            return Response.error((String)"Can't delete last status");
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }

    @Resource(method={HttpMethod.POST})
    @Ajax
    @MimeType.HTML
    public Response createStatus(String name, Long projectId, SecurityContext securityContext) {
        try {
            Project project = this.projectService.getProjectById(projectId);
            Status status = this.statusService.createStatus(project, name);
            return this.listTasks(null, projectId, null, null, null, null, "board", securityContext);
        }
        catch (AbstractEntityException e) {
            return Response.status((int)e.getHttpStatusCode()).body((CharSequence)e.getMessage());
        }
    }
}

