/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.util;

import java.lang.constant.Constable;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.Status;
import org.exoplatform.task.domain.Task;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.DateUtil;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtil {
    public static JSONObject buildTaskJSon(Task task, ResourceBundle bundle) {
        if (task == null) {
            throw new IllegalArgumentException("Task must not be null");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("id", task.getId());
            json.put("title", (Object)task.getTitle());
            json.put("completed", task.isCompleted());
            json.put("priority", (Object)task.getPriority());
            if (task.getStatus() != null) {
                JSONObject status = JsonUtil.buildStatusJSON((Status)task.getStatus());
                json.put("status", (Object)status);
            } else {
                json.put("status", false);
            }
            String dueDateCssClass = "";
            String dueDateString = "";
            if (task.getDueDate() != null) {
                UserService userService = (UserService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserService.class);
                TimeZone utz = userService.getUserTimezone(ConversationState.getCurrent().getIdentity().getUserId());
                if (utz == null) {
                    utz = TimeZone.getDefault();
                }
                Calendar c = Calendar.getInstance(utz);
                c.setTime(task.getDueDate());
                dueDateString = DateUtil.formatDueDate((Calendar)c, (ResourceBundle)bundle);
                if (DateUtil.isOverdue((Calendar)c)) {
                    dueDateCssClass = "uiIconColorWarningInRed";
                } else if (DateUtil.isToday((Calendar)c)) {
                    dueDateCssClass = "uiIconColorWarningInBlue";
                }
            }
            json.put("dueDateCssClass", (Object)dueDateCssClass);
            json.put("dueDateString", (Object)dueDateString);
            json.put("dueDate", (Object)(task.getDueDate() != null ? (Constable)Long.valueOf(task.getDueDate().getTime()) : (Constable)Boolean.valueOf(false)));
            return json;
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public static JSONObject buildStatusJSON(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status can not be null");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("id", status.getId());
            json.put("name", (Object)status.getName());
            json.put("rank", (Object)status.getRank());
            JSONObject project = JsonUtil.buildProjectJSON((Project)status.getProject());
            json.put("project", (Object)project);
            return json;
        }
        catch (JSONException ex) {
            return null;
        }
    }

    public static JSONObject buildProjectJSON(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Project can not be null");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("id", project.getId());
            json.put("name", (Object)project.getName());
            json.put("color", (Object)project.getColor());
            return json;
        }
        catch (JSONException ex) {
            return null;
        }
    }
}

