/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.Path;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.Phase;
import juzu.request.RequestContext;
import juzu.request.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.management.templates.messageDialog;

public class AbstractController
implements RequestLifeCycle {
    protected final Log LOG = ExoLogger.getExoLogger(this.getClass());
    @Inject
    ResourceBundle bundle;
    @Inject
    @Path(value="messageDialog.gtmpl")
    messageDialog messageDialog;
    private String noPermissionMsg;

    public Response buildMSGDialog(String message, MSG_TYPE msgType) {
        return this.messageDialog.with().msg((Object)message).type((Object)msgType).ok().withCharset(Tools.UTF_8);
    }

    protected String getNoPermissionMsg() {
        if (this.noPermissionMsg == null) {
            this.noPermissionMsg = this.bundle.getString("popup.msg.noPermission");
        }
        return this.noPermissionMsg;
    }

    public void beginRequest(RequestContext context) {
    }

    public void endRequest(RequestContext context) {
        Response.Error error;
        Throwable ex;
        Response res = context.getResponse();
        if (res instanceof Response.Error && (ex = (error = (Response.Error)res).getCause()) != null) {
            if (!(ex instanceof UnAuthorizedOperationException)) {
                this.LOG.error((Object)"Exception while process request", ex);
            }
            if (context.getPhase() == Phase.RESOURCE) {
                Response.Body response = null;
                if (ex instanceof EntityNotFoundException) {
                    response = Response.status((int)404).body((CharSequence)ex.getMessage());
                } else if (ex instanceof NotAllowedOperationOnEntityException) {
                    response = Response.status((int)403).body((CharSequence)ex.getMessage());
                } else if (ex instanceof UnAuthorizedOperationException) {
                    response = Response.status((int)401).body((CharSequence)ex.getMessage());
                } else if (ex instanceof ParameterEntityException) {
                    response = Response.status((int)406).body((CharSequence)ex.getMessage());
                }
                if (response != null) {
                    context.setResponse((Response)response);
                }
            }
        }
    }
}

