/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.management.templates.taskFilter;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FilterController {
    private static final Log LOG = ExoLogger.getExoLogger(FilterController.class);
    @Inject
    TaskService taskService;
    @Inject
    UserService userService;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    ResourceBundle bundle;
    @Inject
    @Path(value="taskFilter.gtmpl")
    taskFilter taskFilter;

    @Resource
    @Ajax
    @MimeType.HTML
    public Response showFilter(Long projectId, Long labelId, String filter, SecurityContext securityContext) throws JSONException, EntityNotFoundException {
        Project project;
        String username = securityContext.getRemoteUser();
        boolean filterLabel = labelId == null || labelId <= 0L;
        boolean filterStatus = projectId != null && projectId > 0L;
        Project project2 = project = filterStatus ? this.projectService.getProject(projectId) : null;
        if (project != null && !project.canView(ConversationState.getCurrent().getIdentity())) {
            project = null;
        }
        List status = Collections.emptyList();
        if (filterStatus && project != null) {
            status = this.statusService.getStatuses(project.getId());
        }
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List<Object> labels = Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1));
        JSONArray lblArr = this.buildJSON(labels);
        boolean filterAssignee = projectId == null || projectId != -1L;
        boolean filterDueDate = filter == null || filter.isEmpty();
        return this.taskFilter.with().labels((Object)lblArr).filterLabel((Object)filterLabel).status((Object)status).filterStatus((Object)filterStatus).filterAssignee((Object)filterAssignee).filterDueDate((Object)filterDueDate).ok().withCharset(Tools.UTF_8);
    }

    private JSONArray buildJSON(List<Label> labels) throws JSONException {
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        JSONArray jsons = new JSONArray();
        for (Label lbl : labels) {
            JSONObject obj = new JSONObject();
            obj.put("id", lbl.getId());
            obj.put("name", (Object)encoder.encode(lbl.getName()));
            obj.put("color", (Object)lbl.getColor());
            jsons.put((Object)obj);
        }
        return jsons;
    }
}

