/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.service;

import javax.inject.Inject;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.task.management.model.ViewType;

public class ViewStateService {
    public static final Scope TASK_APP_SCOPE = Scope.APPLICATION.id("taskManagement");
    private final SettingService settingService;

    @Inject
    public ViewStateService(SettingService settingService) {
        this.settingService = settingService;
    }

    public ViewType getViewType(String username, long projectId) {
        SettingValue value;
        if (projectId > 0L && (value = this.settingService.get(Context.USER.id(username), TASK_APP_SCOPE, this.buildViewTypeKey(projectId))) != null) {
            return ViewType.getViewType((String)((String)value.getValue()));
        }
        return ViewType.LIST;
    }

    public void saveViewType(String username, long projectId, ViewType viewType) {
        if (projectId > 0L) {
            SettingValue value = new SettingValue((Object)viewType.name());
            this.settingService.set(Context.USER.id(username), TASK_APP_SCOPE, this.buildViewTypeKey(projectId), value);
        }
    }

    private String buildViewTypeKey(long projectId) {
        return "project." + projectId + ".view_type";
    }
}

