/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.domain.Label;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.management.templates.confirmDeleteLabel;
import org.exoplatform.task.management.templates.editLabelDialog;
import org.exoplatform.task.management.templates.listLabels;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.TaskUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class LabelController
extends AbstractController {
    private static final Log LOG = ExoLogger.getExoLogger(LabelController.class);
    @Inject
    TaskService taskService;
    @Inject
    UserService userService;
    @Inject
    ResourceBundle bundle;
    @Inject
    @Path(value="listLabels.gtmpl")
    listLabels listLabels;
    @Inject
    @Path(value="editLabelDialog.gtmpl")
    editLabelDialog editLabelDialog;
    @Inject
    @Path(value="confirmDeleteLabel.gtmpl")
    confirmDeleteLabel confirmDeleteLabel;

    @Resource
    @Ajax
    @MimeType.HTML
    public Response getAllLabels(SecurityContext securityContext) throws JSONException {
        String username = securityContext.getRemoteUser();
        ListAccess tmp = this.taskService.findLabelsByUser(username);
        List<Object> roots = Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1));
        List labels = TaskUtil.buildRootLabels(roots);
        return this.listLabels.with().labels((Object)labels).currentLabelId((Object)-1).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response createLabel(String name, Long parentId, SecurityContext securityContext) throws UnAuthorizedOperationException {
        String username = securityContext.getRemoteUser();
        if (name != null && !(name = name.trim()).isEmpty()) {
            Label label = new Label(name, username);
            if (parentId != null && parentId > 0L) {
                Label parent = this.taskService.getLabel(parentId.longValue());
                if (!parent.getUsername().equals(username)) {
                    throw new UnAuthorizedOperationException(parentId, Label.class, this.getNoPermissionMsg());
                }
                label.setParent(parent);
            }
            this.taskService.createLabel(label);
            try {
                JSONObject json = new JSONObject();
                json.put("id", label.getId());
                return Response.ok((CharSequence)json.toString()).withCharset(Tools.UTF_8);
            }
            catch (JSONException ex) {
                LOG.error((Object)ex);
            }
        }
        return Response.status((int)503);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openConfirmDeleteLabelDialog(Long labelId, SecurityContext context) throws UnAuthorizedOperationException {
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            String username = label.getUsername();
            if (username.equals(context.getRemoteUser())) {
                return this.confirmDeleteLabel.with().label((Object)label).bundle((Object)this.bundle).ok().withCharset(Tools.UTF_8);
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    public Response deleteLabel(Long labelId, SecurityContext securityContext) throws UnAuthorizedOperationException {
        String username = securityContext.getRemoteUser();
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            if (label.getUsername().equals(username)) {
                this.taskService.removeLabel(labelId.longValue());
                return Response.ok();
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openEditLabelDialog(Long labelId, SecurityContext context) throws UnAuthorizedOperationException {
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            String username = label.getUsername();
            if (username.equals(context.getRemoteUser())) {
                ListAccess tmp = this.taskService.findLabelsByUser(username);
                List allLabels = Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1));
                allLabels = TaskUtil.filterLabelTree(allLabels, (Label)label);
                return this.editLabelDialog.with().lblTree((Object)TaskUtil.buildRootLabels((List)allLabels)).lbl((Object)label).ok().withCharset(Tools.UTF_8);
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    public Response changeColor(Long labelId, String color, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        String username = securityContext.getRemoteUser();
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            if (label.getUsername().equals(username)) {
                label.setColor(color);
                this.taskService.updateLabel(label, Arrays.asList(Label.FIELDS.COLOR));
                return Response.ok();
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    public Response toggleHidden(Long labelId, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        String username = securityContext.getRemoteUser();
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            if (label.getUsername().equals(username)) {
                label.setHidden(!label.isHidden());
                this.taskService.updateLabel(label, Arrays.asList(Label.FIELDS.HIDDEN));
                return Response.ok();
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    public Response toggleShowHiddenLabel(SecurityContext securityContext) throws EntityNotFoundException {
        String username;
        UserSetting userSetting = this.userService.getUserSetting(username = securityContext.getRemoteUser());
        this.userService.showHiddenLabel(username, !userSetting.isShowHiddenLabel());
        return Response.ok();
    }

    @Resource
    @Ajax
    public Response updateLabel(Long labelId, String lblName, Long parentId, SecurityContext securityContext) throws EntityNotFoundException, UnAuthorizedOperationException {
        String username = securityContext.getRemoteUser();
        Label label = this.taskService.getLabel(labelId.longValue());
        if (label != null) {
            if (label.getUsername().equals(username)) {
                if (lblName != null && !(lblName = lblName.trim()).isEmpty()) {
                    label.setParent(this.taskService.getLabel(parentId.longValue()));
                    label.setName(lblName);
                    this.taskService.updateLabel(label, Arrays.asList(Label.FIELDS.NAME, Label.FIELDS.PARENT));
                    return Response.ok();
                }
                return Response.status((int)503);
            }
            throw new UnAuthorizedOperationException(labelId, Label.class, this.getNoPermissionMsg());
        }
        return Response.status((int)404);
    }
}

