/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.service;

import javax.inject.Inject;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.task.domain.Priority;
import org.exoplatform.task.management.model.ViewState;
import org.exoplatform.task.management.model.ViewType;
import org.exoplatform.task.util.TaskUtil;

public class ViewStateService {
    public static final Scope TASK_APP_SCOPE = Scope.APPLICATION.id("taskManagement");
    private final SettingService settingService;

    @Inject
    public ViewStateService(SettingService settingService) {
        this.settingService = settingService;
    }

    public ViewState getViewState(String listId) {
        ViewState viewState = new ViewState(listId);
        SettingValue value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".orderBy");
        if (value != null) {
            viewState.setOrderBy((String)value.getValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".groupBy")) != null) {
            viewState.setGroupBy((String)value.getValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".viewType")) != null) {
            viewState.setViewType(ViewType.valueOf((String)((String)value.getValue())));
        } else {
            viewState.setViewType(ViewType.LIST);
        }
        return viewState;
    }

    public void saveViewState(ViewState viewState) {
        ViewState oldViewState = this.getViewState(viewState.getId());
        if (!viewState.isEmpty() && !viewState.equals((Object)oldViewState)) {
            String prefixId = viewState.getId();
            if (viewState.getOrderBy() != null) {
                this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".orderBy", SettingValue.create((String)viewState.getOrderBy()));
            } else {
                this.settingService.remove(Context.USER, TASK_APP_SCOPE, prefixId + ".orderBy");
            }
            if (viewState.getGroupBy() != null) {
                this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".groupBy", SettingValue.create((String)viewState.getGroupBy()));
            } else {
                this.settingService.remove(Context.USER, TASK_APP_SCOPE, prefixId + ".groupBy");
            }
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".viewType", SettingValue.create((String)viewState.getViewType().toString()));
        }
    }

    public ViewState.Filter getFilter(String listId) {
        ViewState.Filter filter = new ViewState.Filter(listId);
        SettingValue value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.enabled");
        if (value != null) {
            filter.setEnabled(Boolean.valueOf((String)value.getValue()).booleanValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.keyword")) != null) {
            filter.setKeyword((String)value.getValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.status")) != null) {
            filter.setStatus(Long.valueOf((String)value.getValue()));
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.showCompleted")) != null) {
            filter.setShowCompleted(Boolean.valueOf((String)value.getValue()).booleanValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.due")) != null) {
            filter.setDue(TaskUtil.DUE.valueOf((String)((String)value.getValue())));
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.priority")) != null) {
            filter.setPriority(Priority.valueOf((String)((String)value.getValue())));
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.labels")) != null) {
            filter.setLabels((String)value.getValue());
        }
        if ((value = this.settingService.get(Context.USER, TASK_APP_SCOPE, listId + ".filter.assignees")) != null) {
            filter.setAssignees((String)value.getValue());
        }
        return filter;
    }

    public void saveFilter(ViewState.Filter filter) {
        ViewState.Filter originalFilter = this.getFilter(filter.getId());
        if (!filter.equals((Object)originalFilter)) {
            String prefixId = filter.getId();
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.enabled", SettingValue.create((String)String.valueOf(filter.isEnabled())));
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.keyword", SettingValue.create((String)filter.getKeyword()));
            if (filter.getStatus() != null) {
                this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.status", SettingValue.create((String)String.valueOf(filter.getStatus())));
            } else {
                this.settingService.remove(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.status");
            }
            if (filter.getDue() != null) {
                this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.due", SettingValue.create((String)filter.getDue().toString()));
            } else {
                this.settingService.remove(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.due");
            }
            if (filter.getPriority() != null) {
                this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.priority", SettingValue.create((String)filter.getPriority().toString()));
            } else {
                this.settingService.remove(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.priority");
            }
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.labels", SettingValue.create((String)filter.getLabelsInString()));
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.assignees", SettingValue.create((String)filter.getAssigneesInString()));
            this.settingService.set(Context.USER, TASK_APP_SCOPE, prefixId + ".filter.showCompleted", SettingValue.create((String)String.valueOf(filter.isShowCompleted())));
        }
    }
}

