/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.management.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import juzu.MimeType;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.impl.common.Tools;
import juzu.request.SecurityContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.domain.Project;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.ParameterEntityException;
import org.exoplatform.task.exception.UnAuthorizedOperationException;
import org.exoplatform.task.management.controller.AbstractController;
import org.exoplatform.task.management.templates.confirmDeleteProject;
import org.exoplatform.task.management.templates.groupSelectorDialog;
import org.exoplatform.task.management.templates.listProjects;
import org.exoplatform.task.management.templates.permissionSuggest;
import org.exoplatform.task.management.templates.projectDetail;
import org.exoplatform.task.management.templates.projectForm;
import org.exoplatform.task.management.templates.projectSearchResult;
import org.exoplatform.task.management.templates.shareDialog;
import org.exoplatform.task.management.templates.userSelectorDialog;
import org.exoplatform.task.model.Permission;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.UserService;
import org.exoplatform.task.util.ListUtil;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.StringUtil;
import org.exoplatform.task.util.TaskUtil;
import org.exoplatform.task.util.UserUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectController
extends AbstractController {
    @Inject
    ResourceBundle bundle;
    @Inject
    ProjectService projectService;
    @Inject
    StatusService statusService;
    @Inject
    UserService userService;
    @Inject
    OrganizationService orgService;
    @Inject
    UserACL userACL;
    @Inject
    @Path(value="projectForm.gtmpl")
    projectForm form;
    @Inject
    @Path(value="projectDetail.gtmpl")
    projectDetail detail;
    @Inject
    @Path(value="listProjects.gtmpl")
    listProjects listProjects;
    @Inject
    @Path(value="shareDialog.gtmpl")
    shareDialog shareDialog;
    @Inject
    @Path(value="confirmDeleteProject.gtmpl")
    confirmDeleteProject confirmDeleteProject;
    @Inject
    @Path(value="userSelectorDialog.gtmpl")
    userSelectorDialog userSelectorDialog;
    @Inject
    @Path(value="groupSelectorDialog.gtmpl")
    groupSelectorDialog groupSelectorDialog;
    @Inject
    @Path(value="projectSearchResult.gtmpl")
    projectSearchResult projectSearchResult;
    @Inject
    @Path(value="permissionSuggest.gtmpl")
    permissionSuggest permissionSuggest;
    private static final Log LOG = ExoLogger.getExoLogger(ProjectController.class);

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectForm(Long parentId, SecurityContext securityContext) throws UnAuthorizedOperationException {
        Project parent;
        try {
            parent = this.projectService.getProject(parentId);
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (!parent.canEdit(identity)) {
                throw new UnAuthorizedOperationException(parentId, Project.class, this.getNoPermissionMsg());
            }
        }
        catch (EntityNotFoundException e) {
            parent = new Project();
        }
        org.exoplatform.task.model.User user = this.userService.loadUser(securityContext.getRemoteUser());
        return this.form.with().breadcumbs((Object)ProjectUtil.buildBreadcumbs((Long)parent.getId(), (ProjectService)this.projectService, (ResourceBundle)this.bundle)).useCalendar((Object)TaskUtil.isCalendarEnabled()).parent((Object)parent).user((Object)user).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response createProject(String space_group_id, String name, String description, Long parentId, Boolean calInteg, SecurityContext securityContext) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        Project project;
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null) {
            return Response.status((int)401).body((CharSequence)"You must login to create new project");
        }
        if (name == null || name.isEmpty()) {
            return Response.status((int)412).body((CharSequence)"Name of project is required");
        }
        description = StringUtil.encodeInjectedHtmlTag((String)description);
        if (space_group_id != null) {
            List memberships = UserUtil.getSpaceMemberships((String)space_group_id);
            HashSet<String> managers = new HashSet<String>(Arrays.asList(currentUser, (String)memberships.get(0)));
            HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
            project = ProjectUtil.newProjectInstance((String)name, (String)description, managers, participators);
        } else {
            project = ProjectUtil.newProjectInstance((String)name, (String)description, (String)currentUser);
        }
        calInteg = calInteg == null ? false : calInteg;
        project.setCalendarIntegrated(calInteg.booleanValue());
        if (parentId != null && parentId > 0L) {
            Project parent = this.projectService.getProject(parentId);
            if (!parent.canEdit(ConversationState.getCurrent().getIdentity())) {
                throw new UnAuthorizedOperationException(parentId, Project.class, this.getNoPermissionMsg());
            }
            project = this.projectService.createProject(project, parentId.longValue());
        } else {
            project = this.projectService.createProject(project);
            this.statusService.createInitialStatuses(project);
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        JSONObject result = new JSONObject();
        result.put("id", project.getId());
        result.put("name", (Object)encoder.encode(project.getName()));
        result.put("color", (Object)"transparent");
        return Response.ok((CharSequence)result.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response cloneProject(Long id, String cloneTask, SecurityContext securityContext) throws EntityNotFoundException, JSONException, UnAuthorizedOperationException {
        Project currentProject = this.projectService.getProject(id);
        if (!currentProject.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
        }
        Project project = this.projectService.cloneProject(id.longValue(), Boolean.parseBoolean(cloneTask));
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        JSONObject result = new JSONObject();
        result.put("id", project.getId());
        result.put("name", (Object)encoder.encode(project.getName()));
        result.put("color", (Object)project.getColor());
        return Response.ok((CharSequence)result.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openConfirmDelete(Long id) throws EntityNotFoundException, UnAuthorizedOperationException {
        Project project = this.projectService.getProject(id);
        if (project != null) {
            if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
                throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
            }
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            String msg = this.bundle.getString("popup.msg.deleteProject");
            msg = msg.replace("{}", encoder.encode(project.getName()));
            return this.confirmDeleteProject.with().pid((Object)project.getId()).msg((Object)msg).ok().withCharset(Tools.UTF_8);
        }
        return Response.status((int)404);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openShareDialog(Long id) throws EntityNotFoundException, UnAuthorizedOperationException {
        Project project = this.projectService.getProject(id);
        if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
        }
        return this.renderShareDialog(project, "");
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openUserSelector(Long id, String type, Integer page, String keyword, String filter) throws EntityNotFoundException, Exception {
        int length;
        int start;
        int totalPage;
        int pageSize = 10;
        int total = 0;
        if (page == null) {
            page = 0;
        }
        boolean hasNext = true;
        ListAccess list = null;
        UserHandler uHandler = this.orgService.getUserHandler();
        if (keyword != null && !keyword.isEmpty()) {
            String searchKeyword = keyword;
            if (searchKeyword.indexOf("*") < 0) {
                if (searchKeyword.charAt(0) != '*') {
                    searchKeyword = "*" + searchKeyword;
                }
                if (searchKeyword.charAt(searchKeyword.length() - 1) != '*') {
                    searchKeyword = searchKeyword + "*";
                }
            }
            searchKeyword = searchKeyword.replace('?', '_');
            Query q = new Query();
            if ("userName".equals(filter)) {
                q.setUserName(searchKeyword);
            }
            if ("lastName".equals(filter)) {
                q.setLastName(searchKeyword);
            }
            if ("firstName".equals(filter)) {
                q.setFirstName(searchKeyword);
            }
            if ("email".equals(filter)) {
                q.setEmail(searchKeyword);
            }
            list = uHandler.findUsersByQuery(q);
        } else {
            list = uHandler.findAllUsers();
        }
        total = ListUtil.getSize((ListAccess)list);
        int n = totalPage = total >= 0 ? (int)Math.ceil((float)total / (float)pageSize) : -1;
        if (page > totalPage) {
            page = totalPage > 0 ? totalPage : 0;
        }
        if ((start = page * pageSize) + (length = pageSize) > total) {
            length = total - start;
        }
        User[] uArr = (User[])list.load(start, length);
        List<User> users = Arrays.asList(uArr);
        return this.userSelectorDialog.with().type((Object)type).users(users).keyword((Object)(keyword == null ? "" : keyword)).filter((Object)(filter == null ? "" : filter)).currentPage((Object)page).totalPage((Object)totalPage).hasNext((Object)hasNext).ok();
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openGroupSelector(String type, Boolean onlyGroup) {
        Collection msTypes;
        Collection groups;
        try {
            ConversationState conversationState = ConversationState.getCurrent();
            groups = conversationState != null && conversationState.getIdentity() != null ? (Collection)this.orgService.getGroupHandler().getAllGroups().stream().filter(group -> this.userACL.hasPermission(conversationState.getIdentity(), group, "tasks_projects_permissions")).collect(Collectors.toList()) : Collections.EMPTY_LIST;
            msTypes = this.orgService.getMembershipTypeHandler().findMembershipTypes();
        }
        catch (Exception e) {
            return Response.status((int)503).body((CharSequence)e.getMessage());
        }
        List allGroups = new ArrayList();
        if (groups != null) {
            allGroups = UserUtil.buildGroupTree((Collection)groups);
        }
        ArrayList<String> allMSTypes = new ArrayList<String>();
        if (msTypes != null) {
            for (Object mst : msTypes) {
                allMSTypes.add(((MembershipType)mst).getName());
            }
        }
        if (onlyGroup == null) {
            onlyGroup = Boolean.FALSE;
        }
        return this.groupSelectorDialog.with().type((Object)type).groups(allGroups).membershipTypes(allMSTypes).groupOnly((Object)onlyGroup).ok();
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response findPermission(String keyword) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        try {
            ListAccess list = this.userService.findUserByName(keyword);
            for (org.exoplatform.task.model.User u : (org.exoplatform.task.model.User[])list.load(0, 10)) {
                permissions.add(new Permission(1, u.getUsername(), u.getDisplayName()));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)ex);
        }
        if (permissions.size() < 10) {
            try {
                for (Group g : this.orgService.getGroupHandler().getAllGroups()) {
                    if (g.getLabel().toLowerCase().contains(keyword)) {
                        String perm = "*:" + g.getId();
                        String displayName = this.bundle.getString("label.any") + " " + this.bundle.getString("label.in") + " " + g.getLabel();
                        Permission p = new Permission(2, perm, displayName);
                        p.setGroupId(g.getId());
                        p.setGroupName(g.getLabel());
                        p.setMembershipType("*");
                        permissions.add(p);
                    }
                    if (permissions.size() != 10) continue;
                    break;
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex);
            }
        }
        return this.permissionSuggest.with().keyword((Object)keyword).permissions(permissions).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response savePermission(Long id, String[] permissions, String type) throws EntityNotFoundException, ParameterEntityException, UnAuthorizedOperationException {
        String name = "manager".equals(type) ? type : "participator";
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put(name, permissions);
        if ("manager".equals(type) && (permissions == null || permissions.length == 0)) {
            return Response.status((int)406).body((CharSequence)this.bundle.getString("popup.shareProject.msg.noManager")).withCharset(Tools.UTF_8);
        }
        Project project = this.projectService.getProject(id);
        if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
        }
        project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)id, fields);
        this.projectService.updateProject(project);
        return this.renderShareDialog(project, "");
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectTree(String space_group_id, SecurityContext securityContext) {
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        UserSetting setting = this.userService.getUserSetting(securityContext.getRemoteUser());
        return this.listProjects.with().userSetting((Object)setting).projects((Object)projects).currentProjectId((Object)-100).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.JSON
    public Response projectTreeAsJSON(String space_group_id) throws JSONException {
        List projects = ProjectUtil.getProjectTree((String)space_group_id, (ProjectService)this.projectService);
        Project root = new Project();
        root.setName(this.bundle.getString("label.projects"));
        projects.add(0, root);
        JSONArray array = new JSONArray();
        this.buildJSON(array, projects);
        return Response.ok((CharSequence)array.toString()).withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response getBreadCumbs(Long id, Boolean isBreadcrumb) throws UnAuthorizedOperationException {
        String breadcrumbs = "";
        Project p = null;
        try {
            p = this.projectService.getProject(id);
            if (!p.canEdit(ConversationState.getCurrent().getIdentity())) {
                throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
        breadcrumbs = isBreadcrumb == null || isBreadcrumb != false ? ProjectUtil.buildBreadcumbs((Long)id, (ProjectService)this.projectService, (ResourceBundle)this.bundle) : (p != null ? "<li class=\"active\"><a class=\"project-name\" href=\"javascript:void(0)\">" + encoder.encode(p.getName()) + "</a></li>" : "<li class=\"muted\">" + this.bundle.getString("label.noProject") + "</li>");
        return Response.ok((CharSequence)breadcrumbs.toString()).withCharset(Tools.UTF_8);
    }

    private JSONArray buildJSON(JSONArray array, List<Project> projects) throws JSONException {
        for (Project p : projects) {
            JSONObject json = new JSONObject();
            json.put("id", p.getId());
            json.put("text", (Object)p.getName());
            array.put((Object)json);
            if (p.getChildren() == null) continue;
            this.buildJSON(array, p.getChildren());
        }
        return array;
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response projectDetail(Long id) throws EntityNotFoundException, UnAuthorizedOperationException {
        Project parent;
        Project project = this.projectService.getProject(id);
        if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(id, Project.class, this.getNoPermissionMsg());
        }
        LinkedList<String> groups = new LinkedList<String>();
        HashMap<String, org.exoplatform.task.model.User> users = new HashMap<String, org.exoplatform.task.model.User>();
        if (project.getManager() != null && !project.getManager().isEmpty()) {
            for (String man : project.getManager()) {
                Permission per = Permission.parse((String)man, (ResourceBundle)this.bundle, (OrganizationService)this.orgService);
                if (per.getType() == 1) {
                    org.exoplatform.task.model.User user = this.userService.loadUser(man);
                    users.put(man, user);
                    continue;
                }
                groups.add(per.getDisplayName());
            }
        }
        if ((parent = project.getParent()) == null) {
            parent = new Project();
        }
        return this.detail.with().breadcumbs((Object)ProjectUtil.buildBreadcumbs((Long)parent.getId(), (ProjectService)this.projectService, (ResourceBundle)this.bundle)).useCalendar((Object)TaskUtil.isCalendarEnabled()).parent((Object)parent).project((Object)project).userMap(users).groups(groups).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response saveProjectInfo(Long projectId, String parent, String name, String description, String calendarIntegrated) throws EntityNotFoundException, ParameterEntityException, UnAuthorizedOperationException {
        if (name == null) {
            return Response.status((int)406).body((CharSequence)"Field name is required");
        }
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (parent != null && !parent.isEmpty()) {
            Long parentId = Long.parseLong(parent);
            try {
                if (!this.projectService.getProject(parentId).canEdit(identity)) {
                    throw new UnAuthorizedOperationException(parentId, Project.class, this.getNoPermissionMsg());
                }
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }
        if (!this.projectService.getProject(projectId).canEdit(identity)) {
            throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
        }
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("name", new String[]{name});
        description = StringUtil.encodeInjectedHtmlTag((String)description);
        fields.put("description", new String[]{description});
        fields.put("parent", new String[]{parent});
        fields.put("calendarIntegrated", new String[]{calendarIntegrated});
        Project project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)projectId, fields);
        this.projectService.updateProject(project);
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response changeProjectColor(Long projectId, String color) throws EntityNotFoundException, ParameterEntityException, UnAuthorizedOperationException {
        HashMap<String, String[]> fields = new HashMap<String, String[]>();
        fields.put("color", new String[]{color});
        Project project = this.projectService.getProject(projectId);
        if (!project.canEdit(ConversationState.getCurrent().getIdentity())) {
            throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
        }
        project = ProjectUtil.saveProjectField((ProjectService)this.projectService, (long)projectId, fields);
        this.projectService.updateProject(project);
        return Response.ok((CharSequence)"Update successfully");
    }

    @Resource
    @Ajax
    @MimeType(value={"text/plain"})
    public Response deleteProject(Long projectId, Boolean deleteChild) throws EntityNotFoundException, UnAuthorizedOperationException {
        Identity identity = ConversationState.getCurrent().getIdentity();
        Project project = this.projectService.getProject(projectId);
        if (!project.canEdit(identity)) {
            throw new UnAuthorizedOperationException(projectId, Project.class, this.getNoPermissionMsg());
        }
        if (deleteChild.booleanValue()) {
            ListAccess childs = this.projectService.getSubProjects(projectId.longValue());
            for (Project child : (Project[])ListUtil.load((ListAccess)childs, (int)0, (int)-1)) {
                if (child.canEdit(identity)) continue;
                throw new UnAuthorizedOperationException(Long.valueOf(child.getId()), Project.class, this.getNoPermissionMsg());
            }
        }
        this.projectService.removeProject(projectId.longValue(), deleteChild.booleanValue());
        return Response.ok((CharSequence)"Delete project successfully");
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response findProject(String keyword, Long currentProject) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        ListAccess tmp = this.projectService.findProjects(UserUtil.getMemberships((Identity)identity), keyword, null);
        List projects = Arrays.asList(ListUtil.load((ListAccess)tmp, (int)0, (int)-1));
        projects = ProjectUtil.buildRootProjects(projects);
        return this.projectSearchResult.with().keyword((Object)keyword).projects((Object)projects).identity((Object)identity).currentProjectId((Object)currentProject).ok();
    }

    private Response renderShareDialog(Project project, String editingField) {
        Permission p;
        ArrayList<Permission> managers = new ArrayList<Permission>();
        ArrayList<Permission> participants = new ArrayList<Permission>();
        if (project.getManager() != null && project.getManager().size() > 0) {
            for (String permission : project.getManager()) {
                p = Permission.parse((String)permission, (ResourceBundle)this.bundle, (OrganizationService)this.orgService);
                if (p == null) continue;
                managers.add(p);
            }
        }
        if (project.getParticipator() != null && project.getParticipator().size() > 0) {
            for (String permission : project.getParticipator()) {
                p = Permission.parse((String)permission, (ResourceBundle)this.bundle, (OrganizationService)this.orgService);
                if (p == null) continue;
                participants.add(p);
            }
        }
        ArrayList<String> msTypes = new ArrayList<String>();
        try {
            Collection membershipTypes = this.orgService.getMembershipTypeHandler().findMembershipTypes();
            for (MembershipType type : membershipTypes) {
                msTypes.add(type.getName());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
        return this.shareDialog.with().pid((Object)project.getId()).participants(participants).managers(managers).msTypes(msTypes).editingField((Object)(editingField == null ? "" : editingField)).ok().withCharset(Tools.UTF_8);
    }

    @Resource
    @Ajax
    @MimeType.HTML
    public Response openWarningDialog(String msg) {
        return this.buildMSGDialog(msg, AbstractController.MSG_TYPE.WARNING);
    }
}

