/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.ActivityRecordEntity;

public class ActivityRecordDAO
extends GenericDAOJPAImpl<ActivityRecordEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordDAO.class);
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    public static final String QUERY_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat quryDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public List<ActivityRecordEntity> getUserActivityRecordsList(String day, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ActivityRecordEntity.getActivityRecordsByDay", ActivityRecordEntity.class).setParameter("day", (Object)day).setParameter("userName", (Object)userName);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ActivityRecordEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of activities by day {} and user {}", new Object[]{day, userName, e});
            return new ArrayList<ActivityRecordEntity>();
        }
    }

    public ActivityRecordEntity getLastActivityRecord(String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ActivityRecordEntity.getLastActivityRecord", ActivityRecordEntity.class).setParameter("userName", (Object)userName).setMaxResults(1);
        try {
            return (ActivityRecordEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get last activity by user {}", new Object[]{userName, e});
            return null;
        }
    }

    public List<ActivityRecordEntity> getActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        try {
            Object queryString = "SELECT activityRecord FROM ActivityRecordEntity activityRecord";
            if (StringUtils.isNotEmpty((String)search) || this.isNotEmpty(activity) || this.isNotEmpty(type) || StringUtils.isNotEmpty((String)userName) || this.isNotEmpty(subType) || this.isNotEmpty(activityCode) || this.isNotEmpty(subActivityCode) || this.isNotEmpty(client) || this.isNotEmpty(project) || this.isNotEmpty(feature) || StringUtils.isNotEmpty((String)fromDate) || StringUtils.isNotEmpty((String)toDate) || StringUtils.isNotEmpty((String)location) || StringUtils.isNotEmpty((String)office)) {
                String date;
                queryString = (String)queryString + " where ";
                if (StringUtils.isNotEmpty((String)search)) {
                    search = search.toLowerCase();
                    queryString = (String)queryString + " lower(activityRecord.description) LIKE '%' || '" + search + "'|| '%' or lower(activityRecord.userName) LIKE '%' || '" + search + "' || '%'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(activity)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.id = '" + activity + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(type)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.typeEntity.id = '" + type + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(subType)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.subTypeEntity.id = '" + subType + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(activityCode)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.activityCodeEntity.id = '" + activityCode + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(subActivityCode)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.subActivityCodeEntity.id = '" + subActivityCode + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(client)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.projectEntity.clientEntity.id = '" + client + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(project)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.projectEntity.id = '" + project + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(feature)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.featureEntity.id = '" + feature + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)userName)) {
                    queryString = (String)queryString + " activityRecord.userName = '" + userName + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)location)) {
                    queryString = (String)queryString + " activityRecord.location = '" + location + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)office)) {
                    queryString = (String)queryString + " activityRecord.office= '" + office + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)fromDate)) {
                    try {
                        long from = this.formatter.parse(fromDate).getTime();
                        date = quryDateFormatter.format(from);
                        queryString = (String)queryString + " TIMESTAMP(activityRecord.activityTime) >= '" + date + "'";
                        queryString = (String)queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the from date filer will not applied to get th list of activityRecords");
                    }
                }
                if (StringUtils.isNotEmpty((String)toDate)) {
                    try {
                        Date to = this.formatter.parse(toDate);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(to);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        cal.set(11, 23);
                        date = quryDateFormatter.format(cal.getTime());
                        queryString = (String)queryString + " TIMESTAMP(activityRecord.activityTime) <= '" + date + "'";
                        queryString = (String)queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
                    }
                }
                if (((String)queryString).endsWith(" and ")) {
                    queryString = ((String)queryString).substring(0, ((String)queryString).length() - 5);
                }
            }
            queryString = StringUtils.isNotEmpty((String)sortBy) ? (sortDesc ? (String)queryString + " ORDER BY activityRecord." + sortBy + " DESC" : (String)queryString + " ORDER BY activityRecord." + sortBy + " ASC") : (String)queryString + " ORDER BY activityRecord.activityTime DESC";
            TypedQuery query = this.getEntityManager().createQuery((String)queryString, ActivityRecordEntity.class);
            if (offset >= 0 && limit > 0) {
                query.setFirstResult(offset).setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'."), (Throwable)e);
            throw e;
        }
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        try {
            Object queryString = "SELECT count(activityRecord.id) FROM  ActivityRecordEntity activityRecord";
            if (StringUtils.isNotEmpty((String)search) || this.isNotEmpty(activity) || this.isNotEmpty(type) || StringUtils.isNotEmpty((String)userName) || this.isNotEmpty(subType) || this.isNotEmpty(activityCode) || this.isNotEmpty(subActivityCode) || this.isNotEmpty(client) || this.isNotEmpty(project) || this.isNotEmpty(feature) || StringUtils.isNotEmpty((String)fromDate) || StringUtils.isNotEmpty((String)toDate) || StringUtils.isNotEmpty((String)location) || StringUtils.isNotEmpty((String)office)) {
                String date;
                queryString = (String)queryString + " where ";
                if (StringUtils.isNotEmpty((String)search)) {
                    search = search.toLowerCase();
                    queryString = (String)queryString + " lower(activityRecord.description) LIKE '%' || '" + search + "'|| '%' or lower(activityRecord.userName) LIKE '%' || '" + search + "' || '%'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(activity)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.id = '" + activity + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(type)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.typeEntity.id = '" + type + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(subType)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.subTypeEntity.id = '" + subType + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(activityCode)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.activityCodeEntity.id = '" + activityCode + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(subActivityCode)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.subActivityCodeEntity.id = '" + subActivityCode + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(client)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.projectEntity.clientEntity.id = '" + client + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(project)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.projectEntity.id = '" + project + "'";
                    queryString = (String)queryString + " and ";
                }
                if (this.isNotEmpty(feature)) {
                    queryString = (String)queryString + " activityRecord.activityEntity.featureEntity.id = '" + feature + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)userName)) {
                    queryString = (String)queryString + " activityRecord.userName = '" + userName + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)location)) {
                    queryString = (String)queryString + " activityRecord.location = '" + location + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)office)) {
                    queryString = (String)queryString + " activityRecord.office= '" + office + "'";
                    queryString = (String)queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)fromDate)) {
                    try {
                        long from = this.formatter.parse(fromDate).getTime();
                        date = quryDateFormatter.format(from);
                        queryString = (String)queryString + " TIMESTAMP(activityRecord.activityTime) >= '" + date + "'";
                        queryString = (String)queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the from date filer will not applied to get th list of activityRecords");
                    }
                }
                if (StringUtils.isNotEmpty((String)toDate)) {
                    try {
                        Date to = this.formatter.parse(toDate);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(to);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        cal.set(11, 23);
                        date = quryDateFormatter.format(cal.getTime());
                        queryString = (String)queryString + " TIMESTAMP(activityRecord.activityTime) <= '" + date + "'";
                        queryString = (String)queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
                    }
                }
                if (((String)queryString).endsWith(" and ")) {
                    queryString = ((String)queryString).substring(0, ((String)queryString).length() - 5);
                }
            }
            return (Long)this.getEntityManager().createQuery((String)queryString, Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get activityRecords count.", (Throwable)e);
            throw e;
        }
    }

    boolean isNotEmpty(Long value) {
        return value != null && value > 0L;
    }
}

