/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.RecordsAccessList;
import org.exoplatform.timetracker.service.ActivityRecordService;

@Path(value="timetracker/activityRecordrecordsmgn")
@RolesAllowed(value={"users"})
@Api(value="/timetracker", description="Manage and access ActivityRecord center ActivityRecords")
public class ActivityRecordsManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordsManagementREST.class);
    private final String portalContainerName = "portal";
    private final ActivityRecordService activityRecordService;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public ActivityRecordsManagementREST(ActivityRecordService activityRecordService, PortalContainer container) {
        this.activityRecordService = activityRecordService;
    }

    @GET
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivityRecords() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.activityRecordService.getActivityRecords()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="activityrecord/list")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivityRecordsList(@Context UriInfo uriInfo, @QueryParam(value="search") String search, @QueryParam(value="activity") long activity, @QueryParam(value="type") long type, @QueryParam(value="subType") long subType, @QueryParam(value="activityCode") long activityCode, @QueryParam(value="subActivityCode") long subActivityCode, @QueryParam(value="client") long client, @QueryParam(value="project") long project, @QueryParam(value="feature") long feature, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="userName") String userName, @QueryParam(value="location") String location, @QueryParam(value="office") String office, @QueryParam(value="sortby") String sortBy, @QueryParam(value="sortdesc") Boolean sortDesc, @QueryParam(value="export") Boolean export) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.isEmpty((String)userName)) {
                userName = sourceIdentity.getRemoteId();
            }
            RecordsAccessList recordsAccessList = this.activityRecordService.getActivityRecordsList(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, 0, 0, sortBy, sortDesc);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            List<Object> act = new ArrayList();
            ArrayList<ActivityRecord> activityRecordList = new ArrayList<ActivityRecord>();
            LocalDate from_ = LocalDate.now();
            LocalDate to_ = LocalDate.now();
            try {
                if (StringUtils.isNotEmpty((String)fromDate)) {
                    from_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(fromDate));
                } else {
                    String from = recordsAccessList.getActivityRecords().get(recordsAccessList.getSize().intValue() - 1).getActivityDate();
                    from_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(from));
                }
                if (StringUtils.isNotEmpty((String)toDate)) {
                    to_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(toDate));
                } else {
                    String to = recordsAccessList.getActivityRecords().get(0).getActivityDate();
                    to_ = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(to));
                }
                for (LocalDate d : ActivityRecordsManagementREST.getDatesBetween(from_, to_)) {
                    String day = d.format(this.formatter);
                    act = recordsAccessList.getActivityRecords().stream().filter(c -> c.getActivityDate().equals(day)).collect(Collectors.toList());
                    if (act.size() > 0) {
                        float TimeSum = act.stream().map(x -> x.getTime()).reduce(Float.valueOf(0.0f), (a, b) -> Float.valueOf(a.floatValue() + b.floatValue())).floatValue();
                        for (ActivityRecord activityRecord : act) {
                            activityRecord.setDailyTimeSum(Float.valueOf(TimeSum));
                            if (activityRecord.getProject() != null) {
                                activityRecord.getActivity().setProject(activityRecord.getProject());
                            }
                            if (activityRecord.getClient() != null) {
                                activityRecord.getActivity().getProject().setClient(activityRecord.getClient());
                            }
                            activityRecordList.add(activityRecord);
                        }
                        continue;
                    }
                    Date actDate = Date.from(d.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    DayOfWeek dayOfWeek = d.getDayOfWeek();
                    if (dayOfWeek.getValue() == 6 || dayOfWeek.getValue() == 7) {
                        activityRecordList.add(new ActivityRecord(null, userName, day, actDate, "Week End", "", "", new Float(8.0f), "", null, null, null, null, identityManager.getOrCreateUserIdentity(userName).getProfile().getFullName(), null));
                        continue;
                    }
                    activityRecordList.add(new ActivityRecord(null, userName, day, actDate, "", "", "", new Float(0.0f), "", null, null, null, null, identityManager.getOrCreateUserIdentity(userName).getProfile().getFullName(), null));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
            }
            return Response.ok(activityRecordList).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="activityrecord/last")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivityRecordsList(@Context UriInfo uriInfo, @QueryParam(value="userName") String userName) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.isEmpty((String)userName)) {
                userName = sourceIdentity.getRemoteId();
            }
            return Response.ok((Object)this.activityRecordService.getLastActivityRecord(userName)).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public static List<LocalDate> getDatesBetween(LocalDate startDate, LocalDate endDate) {
        long numOfDaysBetween = ChronoUnit.DAYS.between(startDate, endDate);
        return IntStream.iterate(0, i -> i + 1).limit(numOfDaysBetween + 1L).mapToObj(i -> startDate.plusDays(i)).collect(Collectors.toList());
    }

    @GET
    @Path(value="activityrecord/{day}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getActivityRecords(@PathParam(value="day") String day) {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.activityRecordService.getUserActivityRecordsList(day, sourceIdentity.getRemoteId())).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting ActivityRecords", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new ActivityRecord", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createActivityRecord(@ApiParam(value="ActivityRecord to save", required=true) ActivityRecord activityRecord) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            if (activityRecord.getActivity().getId() == null) {
                activityRecord.setActivity(null);
            }
            activityRecord.setUserName(sourceIdentity.getRemoteId());
            this.activityRecordService.createActivityRecord(activityRecord);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="activityrecord")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates an existing ActivityRecord identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateActivityRecord(@ApiParam(value="ActivityRecord to update", required=true) ActivityRecord activityRecord) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.activityRecordService.updateActivityRecord(activityRecord, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="activityrecord/{activityrecordId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes an existing ActivityRecord identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteActivityRecord(@ApiParam(value="ActivityRecord technical id to delete", required=true) @PathParam(value="activityrecordId") Long activityRecordId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.activityRecordService.deleteActivityRecord(activityRecordId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting ActivityRecord", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=remove-record parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

