/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.Project;
import org.exoplatform.timetracker.storage.ProjectStorage;

public class ProjectService {
    private static final Log LOG = ExoLogger.getLogger(ProjectService.class);
    private final ProjectStorage projectStorage;

    public ProjectService(ProjectStorage projectStorage) {
        this.projectStorage = projectStorage;
    }

    public Project createProject(Project project) throws Exception {
        if (project == null) {
            throw new IllegalArgumentException("Project is mandatory");
        }
        return this.projectStorage.createProject(project);
    }

    public Project updateProject(Project Project2, String username) throws Exception {
        if (Project2 == null) {
            throw new IllegalArgumentException("Project is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ProjectId = Project2.getId();
        if (ProjectId == null) {
            throw new EntityNotFoundException("Project with null id wasn't found");
        }
        Project storedProject = this.projectStorage.getProjectById(ProjectId);
        if (storedProject == null) {
            throw new EntityNotFoundException("Project with id " + ProjectId + " wasn't found");
        }
        return this.projectStorage.updateProject(Project2);
    }

    public void deleteProject(Long projectId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (projectId == null || projectId <= 0L) {
            throw new IllegalArgumentException("ProjectId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Project storedProject = this.projectStorage.getProjectById(projectId);
        if (storedProject == null) {
            throw new EntityNotFoundException("Project with id " + projectId + " not found");
        }
        this.projectStorage.deleteProject(projectId);
    }

    public List<Project> getProjectsList() {
        return this.projectStorage.getProjects();
    }
}

