/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.ActivityDAO;
import org.exoplatform.timetracker.dao.ActivityTeamDAO;
import org.exoplatform.timetracker.dto.Activity;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.entity.ActivityEntity;
import org.exoplatform.timetracker.entity.ActivityTeamEntity;
import org.exoplatform.timetracker.storage.CodesStorage;
import org.exoplatform.timetracker.storage.FeatureStorage;
import org.exoplatform.timetracker.storage.ProjectStorage;
import org.exoplatform.timetracker.storage.TeamStorage;
import org.gatein.api.EntityNotFoundException;

public class ActivityStorage {
    private final ActivityDAO activityDAO;
    private final ActivityTeamDAO activityTeamDAO;
    private final ProjectStorage projectStorage;
    private final FeatureStorage featureStorage;
    private final CodesStorage codesStorage;
    private final TeamStorage teamStorage;

    public ActivityStorage(ActivityDAO activityDAO, ProjectStorage projectStorage, FeatureStorage featureStorage, CodesStorage codesStorage, TeamStorage teamStorage, ActivityTeamDAO activityTeamDAO) {
        this.activityDAO = activityDAO;
        this.projectStorage = projectStorage;
        this.featureStorage = featureStorage;
        this.codesStorage = codesStorage;
        this.teamStorage = teamStorage;
        this.activityTeamDAO = activityTeamDAO;
    }

    public Activity createActivity(Activity activity) throws Exception {
        if (activity == null) {
            throw new IllegalArgumentException("Activity is mandatory");
        }
        ActivityEntity activityEntity = this.toEntity(activity);
        activity.setId(null);
        activityEntity = (ActivityEntity)this.activityDAO.create(activityEntity);
        ArrayList<ActivityTeamEntity> activityTeamEntities = new ArrayList<ActivityTeamEntity>();
        for (Team team : activity.getTeams()) {
            Team team_ = this.teamStorage.getTeamById(team.getId());
            if (team_ == null) continue;
            activityTeamEntities.add(new ActivityTeamEntity(activityEntity, team_.getId()));
        }
        this.activityTeamDAO.createAll(activityTeamEntities);
        return this.toDTO(activityEntity);
    }

    public Activity updateActivity(Activity activity) throws Exception {
        if (activity == null) {
            throw new IllegalArgumentException("Activity is mandatory");
        }
        Long activityId = activity.getId();
        ActivityEntity activityEntity = (ActivityEntity)this.activityDAO.find(activity.getId());
        if (activityEntity == null) {
            throw new EntityNotFoundException("Activity with id " + activityId + " wasn't found");
        }
        activityEntity = this.toEntity(activity);
        activityEntity = (ActivityEntity)this.activityDAO.update(activityEntity);
        this.activityTeamDAO.deleteAll(this.activityTeamDAO.getTeamsByActivity(activityId));
        ArrayList<ActivityTeamEntity> activityTeamEntities = new ArrayList<ActivityTeamEntity>();
        for (Team team : activity.getTeams()) {
            Team team_ = this.teamStorage.getTeamById(team.getId());
            if (team_ == null) continue;
            activityTeamEntities.add(new ActivityTeamEntity(activityEntity, team_.getId()));
        }
        this.activityTeamDAO.createAll(activityTeamEntities);
        return this.toDTO(activityEntity);
    }

    public void deleteActivity(long activityId) throws EntityNotFoundException {
        if (activityId <= 0L) {
            throw new IllegalArgumentException("ActivityId must be a positive integer");
        }
        ActivityEntity activityEntity = (ActivityEntity)this.activityDAO.find(Long.valueOf(activityId));
        if (activityEntity == null) {
            throw new EntityNotFoundException("Activity with id " + activityId + " not found");
        }
        this.activityTeamDAO.deleteAll(this.activityTeamDAO.getTeamsByActivity(activityEntity.getId()));
        this.activityDAO.delete(activityEntity);
    }

    public Activity getActivityById(long ActivityId) {
        if (ActivityId <= 0L) {
            throw new IllegalArgumentException("ActivityId must be a positive integer");
        }
        ActivityEntity ActivityEntity2 = (ActivityEntity)this.activityDAO.find(Long.valueOf(ActivityId));
        return this.toDTO(ActivityEntity2);
    }

    public List<Activity> getActivities() {
        List applicatiions = this.activityDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<Activity> getActivitiesByTeams(List<String> teams) {
        if (teams.size() > 0) {
            List<ActivityTeamEntity> applicatiions = this.activityTeamDAO.getActivitiesByTeams(teams);
            List activities = applicatiions.stream().map(ActivityTeamEntity::getActivityEntity).collect(Collectors.toList());
            return activities.stream().map(this::toDTO).collect(Collectors.toList());
        }
        return new ArrayList<Activity>();
    }

    public long countActivities() {
        return this.activityDAO.count();
    }

    public Activity toDTO(ActivityEntity activityEntity) {
        if (activityEntity == null || activityEntity.getId() == 0L) {
            return null;
        }
        List<ActivityTeamEntity> teamEntities = this.activityTeamDAO.getTeamsByActivity(activityEntity.getId());
        List<String> teams = teamEntities.stream().map(ActivityTeamEntity::getTeamId).collect(Collectors.toList());
        return new Activity(activityEntity.getId(), this.codesStorage.toTypeDTO(activityEntity.getTypeEntity()), this.codesStorage.toSubTypeDTO(activityEntity.getSubTypeEntity()), this.codesStorage.toActivityCodeDTO(activityEntity.getActivityCodeEntity()), this.codesStorage.toSubActivityCodeDTO(activityEntity.getSubActivityCodeEntity()), activityEntity.getLabel(), this.projectStorage.toDTO(activityEntity.getProjectEntity()), this.featureStorage.toDTO(activityEntity.getFeatureEntity()), this.teamStorage.toDtos_(teams));
    }

    public ActivityEntity toEntity(Activity activity) {
        if (activity == null || activity.getId() != null && activity.getId() == 0L) {
            return null;
        }
        return new ActivityEntity(activity.getId(), activity.getLabel(), this.projectStorage.toEntity(activity.getProject()), this.codesStorage.toActivityCodeEntity(activity.getActivityCode()), this.codesStorage.toSubActivityCodeEntity(activity.getSubActivityCode()), this.codesStorage.toTypeEntity(activity.getType()), this.codesStorage.toSubTypeEntity(activity.getSubType()), this.featureStorage.toEntity(activity.getFeature()));
    }
}

