/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.FeatureDAO;
import org.exoplatform.timetracker.dto.Feature;
import org.exoplatform.timetracker.entity.FeatureEntity;
import org.gatein.api.EntityNotFoundException;

public class FeatureStorage {
    private final FeatureDAO featureDAO;

    public FeatureStorage(FeatureDAO featureDAO) {
        this.featureDAO = featureDAO;
    }

    public Feature createFeature(Feature feature) throws Exception {
        if (feature == null) {
            throw new IllegalArgumentException("Feature is mandatory");
        }
        FeatureEntity featureEntity = this.toEntity(feature);
        feature.setId(null);
        featureEntity = (FeatureEntity)this.featureDAO.create(featureEntity);
        return this.toDTO(featureEntity);
    }

    public Feature updateFeature(Feature feature) throws Exception {
        if (feature == null) {
            throw new IllegalArgumentException("Feature is mandatory");
        }
        Long featureId = feature.getId();
        FeatureEntity featureEntity = (FeatureEntity)this.featureDAO.find(feature.getId());
        if (featureEntity == null) {
            throw new EntityNotFoundException("Feature with id " + featureId + " wasn't found");
        }
        featureEntity = this.toEntity(feature);
        featureEntity = (FeatureEntity)this.featureDAO.update(featureEntity);
        return this.toDTO(featureEntity);
    }

    public void deleteFeature(long featureId) throws EntityNotFoundException {
        if (featureId <= 0L) {
            throw new IllegalArgumentException("FeatureId must be a positive integer");
        }
        FeatureEntity featureEntity = (FeatureEntity)this.featureDAO.find(Long.valueOf(featureId));
        if (featureEntity == null) {
            throw new EntityNotFoundException("Feature with id " + featureId + " not found");
        }
        this.featureDAO.delete(featureEntity);
    }

    public Feature getFeatureById(long FeatureId) {
        if (FeatureId <= 0L) {
            throw new IllegalArgumentException("FeatureId must be a positive integer");
        }
        FeatureEntity FeatureEntity2 = (FeatureEntity)this.featureDAO.find(Long.valueOf(FeatureId));
        return this.toDTO(FeatureEntity2);
    }

    public List<Feature> getFeatures() {
        List applicatiions = this.featureDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countFeatures() {
        return this.featureDAO.count();
    }

    public Feature toDTO(FeatureEntity featureEntity) {
        if (featureEntity == null) {
            return null;
        }
        return new Feature(featureEntity.getId(), featureEntity.getCode(), featureEntity.getLabel(), featureEntity.getSpec(), featureEntity.getExo(), null);
    }

    public FeatureEntity toEntity(Feature feature) {
        if (feature == null) {
            return null;
        }
        return new FeatureEntity(feature.getId(), feature.getCode(), feature.getLabel(), feature.getSpec(), feature.getExo());
    }
}

