/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.ActivityTeamEntity;

public class ActivityTeamDAO
extends GenericDAOJPAImpl<ActivityTeamEntity, Serializable> {
    private static final Log LOG = ExoLogger.getLogger(ActivityTeamDAO.class);

    public List<ActivityTeamEntity> getActivitiesByTeams(List<String> teams) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ActivityTeamEntity.getActivitiesByTeams", ActivityTeamEntity.class).setParameter("teams", teams);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ActivityTeamEntity>();
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred when trying to get list of Activities by user teams", (Throwable)e);
            return new ArrayList<ActivityTeamEntity>();
        }
    }

    public List<ActivityTeamEntity> getTeamsByActivity(long activityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ActivityTeamEntity.getTeamsByActivity", ActivityTeamEntity.class).setParameter("activityId", (Object)activityId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ActivityTeamEntity>();
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurred when trying to get list of Activities by user teams", (Throwable)e);
            return new ArrayList<ActivityTeamEntity>();
        }
    }
}

