/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.ActivityRecordEntity;

public class ActivityRecordDAO
extends GenericDAOJPAImpl<ActivityRecordEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordDAO.class);
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    public static final String QUERY_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat quryDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public List<ActivityRecordEntity> getUserActivityRecordsList(String day, String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("ActivityRecordEntity.getActivityRecordsByDay", ActivityRecordEntity.class).setParameter("day", (Object)day).setParameter("userName", (Object)userName);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<ActivityRecordEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of activities by day {} and user {}", new Object[]{day, userName, e});
            return new ArrayList<ActivityRecordEntity>();
        }
    }

    public List<ActivityRecordEntity> getActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        try {
            String queryString = "SELECT activityRecord FROM ActivityRecordEntity activityRecord";
            if (StringUtils.isNotEmpty((String)search) || this.isNotEmpty(activity) || this.isNotEmpty(type) || StringUtils.isNotEmpty((String)userName) || this.isNotEmpty(subType) || this.isNotEmpty(activityCode) || this.isNotEmpty(subActivityCode) || this.isNotEmpty(client) || this.isNotEmpty(project) || this.isNotEmpty(feature) || StringUtils.isNotEmpty((String)fromDate) || StringUtils.isNotEmpty((String)toDate) || StringUtils.isNotEmpty((String)location) || StringUtils.isNotEmpty((String)office)) {
                String date;
                queryString = queryString + " where ";
                if (StringUtils.isNotEmpty((String)search)) {
                    search = search.toLowerCase();
                    queryString = queryString + " lower(activityRecord.description) LIKE '%' || '" + search + "'|| '%' or lower(activityRecord.userName) LIKE '%' || '" + search + "' || '%'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(activity)) {
                    queryString = queryString + " activityRecord.activityEntity.id = '" + activity + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(type)) {
                    queryString = queryString + " activityRecord.activityEntity.typeEntity.id = '" + type + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(subType)) {
                    queryString = queryString + " activityRecord.activityEntity.subTypeEntity.id = '" + subType + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(activityCode)) {
                    queryString = queryString + " activityRecord.activityEntity.activityCodeEntity.id = '" + activityCode + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(subActivityCode)) {
                    queryString = queryString + " activityRecord.activityEntity.subActivityCodeEntity.id = '" + subActivityCode + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(client)) {
                    queryString = queryString + " activityRecord.activityEntity.projectEntity.clientEntity.id = '" + client + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(project)) {
                    queryString = queryString + " activityRecord.activityEntity.projectEntity.id = '" + project + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(feature)) {
                    queryString = queryString + " activityRecord.activityEntity.featureEntity.id = '" + feature + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)userName)) {
                    queryString = queryString + " activityRecord.userName = '" + userName + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)location)) {
                    queryString = queryString + " activityRecord.location = '" + location + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)office)) {
                    queryString = queryString + " activityRecord.office= '" + office + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)fromDate)) {
                    try {
                        long from = this.formatter.parse(fromDate).getTime();
                        date = quryDateFormatter.format(from);
                        queryString = queryString + " TIMESTAMP(activityRecord.activityTime) >= '" + date + "'";
                        queryString = queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the from date filer will not applied to get th list of activityRecords");
                    }
                }
                if (StringUtils.isNotEmpty((String)toDate)) {
                    try {
                        Date to = this.formatter.parse(toDate);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(to);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        cal.set(11, 23);
                        date = quryDateFormatter.format(cal.getTime());
                        queryString = queryString + " TIMESTAMP(activityRecord.activityTime) <= '" + date + "'";
                        queryString = queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
                    }
                }
                if (queryString.endsWith(" and ")) {
                    queryString = queryString.substring(0, queryString.length() - 5);
                }
            }
            queryString = StringUtils.isNotEmpty((String)sortBy) ? (sortDesc ? queryString + " ORDER BY activityRecord." + sortBy + " DESC" : queryString + " ORDER BY activityRecord." + sortBy + " ASC") : queryString + " ORDER BY activityRecord.activityTime DESC";
            TypedQuery query = this.getEntityManager().createQuery(queryString, ActivityRecordEntity.class);
            if (offset >= 0 && limit > 0) {
                query.setFirstResult(offset).setMaxResults(limit);
            }
            return query.getResultList();
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while attempting to get scores with offset = '" + offset + "' and limit = '" + limit + "'."), (Throwable)e);
            throw e;
        }
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        try {
            String queryString = "SELECT count(activityRecord.id) FROM  ActivityRecordEntity activityRecord";
            if (StringUtils.isNotEmpty((String)search) || this.isNotEmpty(activity) || this.isNotEmpty(type) || StringUtils.isNotEmpty((String)userName) || this.isNotEmpty(subType) || this.isNotEmpty(activityCode) || this.isNotEmpty(subActivityCode) || this.isNotEmpty(client) || this.isNotEmpty(project) || this.isNotEmpty(feature) || StringUtils.isNotEmpty((String)fromDate) || StringUtils.isNotEmpty((String)toDate) || StringUtils.isNotEmpty((String)location) || StringUtils.isNotEmpty((String)office)) {
                String date;
                queryString = queryString + " where ";
                if (StringUtils.isNotEmpty((String)search)) {
                    search = search.toLowerCase();
                    queryString = queryString + " lower(activityRecord.description) LIKE '%' || '" + search + "'|| '%' or lower(activityRecord.userName) LIKE '%' || '" + search + "' || '%'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(activity)) {
                    queryString = queryString + " activityRecord.activityEntity.id = '" + activity + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(type)) {
                    queryString = queryString + " activityRecord.activityEntity.typeEntity.id = '" + type + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(subType)) {
                    queryString = queryString + " activityRecord.activityEntity.subTypeEntity.id = '" + subType + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(activityCode)) {
                    queryString = queryString + " activityRecord.activityEntity.activityCodeEntity.id = '" + activityCode + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(subActivityCode)) {
                    queryString = queryString + " activityRecord.activityEntity.subActivityCodeEntity.id = '" + subActivityCode + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(client)) {
                    queryString = queryString + " activityRecord.activityEntity.projectEntity.clientEntity.id = '" + client + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(project)) {
                    queryString = queryString + " activityRecord.activityEntity.projectEntity.id = '" + project + "'";
                    queryString = queryString + " and ";
                }
                if (this.isNotEmpty(feature)) {
                    queryString = queryString + " activityRecord.activityEntity.featureEntity.id = '" + feature + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)userName)) {
                    queryString = queryString + " activityRecord.userName = '" + userName + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)location)) {
                    queryString = queryString + " activityRecord.location = '" + location + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)office)) {
                    queryString = queryString + " activityRecord.office= '" + office + "'";
                    queryString = queryString + " and ";
                }
                if (StringUtils.isNotEmpty((String)fromDate)) {
                    try {
                        long from = this.formatter.parse(fromDate).getTime();
                        date = quryDateFormatter.format(from);
                        queryString = queryString + " TIMESTAMP(activityRecord.activityTime) >= '" + date + "'";
                        queryString = queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the from date filer will not applied to get th list of activityRecords");
                    }
                }
                if (StringUtils.isNotEmpty((String)toDate)) {
                    try {
                        Date to = this.formatter.parse(toDate);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(to);
                        cal.set(12, 59);
                        cal.set(13, 59);
                        cal.set(11, 23);
                        date = quryDateFormatter.format(cal.getTime());
                        queryString = queryString + " TIMESTAMP(activityRecord.activityTime) <= '" + date + "'";
                        queryString = queryString + " and ";
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot parse from date, the to date filer will not applied to get the list of activityRecords");
                    }
                }
                if (queryString.endsWith(" and ")) {
                    queryString = queryString.substring(0, queryString.length() - 5);
                }
            }
            return (Long)this.getEntityManager().createQuery(queryString, Long.class).getSingleResult();
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception while attempting to get activityRecords count.", (Throwable)e);
            throw e;
        }
    }

    boolean isNotEmpty(Long value) {
        return value != null && value > 0L;
    }
}

