/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.SalesOrderDAO;
import org.exoplatform.timetracker.dto.SalesOrder;
import org.exoplatform.timetracker.entity.SalesOrderEntity;
import org.exoplatform.timetracker.storage.ClientStorage;
import org.gatein.api.EntityNotFoundException;

public class SalesOrderStorage {
    private final SalesOrderDAO salesOrderDAO;
    private final ClientStorage clientStorage;

    public SalesOrderStorage(SalesOrderDAO salesOrderDAO, ClientStorage clientStorage) {
        this.salesOrderDAO = salesOrderDAO;
        this.clientStorage = clientStorage;
    }

    public SalesOrder createSalesOrder(SalesOrder salesOrder) throws Exception {
        if (salesOrder == null) {
            throw new IllegalArgumentException("SalesOrder is mandatory");
        }
        SalesOrderEntity salesOrderEntity = this.toEntity(salesOrder);
        salesOrder.setId(null);
        salesOrderEntity = (SalesOrderEntity)this.salesOrderDAO.create(salesOrderEntity);
        return this.toDTO(salesOrderEntity);
    }

    public SalesOrder updateSalesOrder(SalesOrder salesOrder) throws Exception {
        if (salesOrder == null) {
            throw new IllegalArgumentException("SalesOrder is mandatory");
        }
        Long salesOrderId = salesOrder.getId();
        SalesOrderEntity salesOrderEntity = (SalesOrderEntity)this.salesOrderDAO.find(salesOrder.getId());
        if (salesOrderEntity == null) {
            throw new EntityNotFoundException("SalesOrder with id " + salesOrderId + " wasn't found");
        }
        salesOrderEntity = this.toEntity(salesOrder);
        salesOrderEntity = (SalesOrderEntity)this.salesOrderDAO.update(salesOrderEntity);
        return this.toDTO(salesOrderEntity);
    }

    public void deleteSalesOrder(long salesOrderId) throws EntityNotFoundException {
        if (salesOrderId <= 0L) {
            throw new IllegalArgumentException("SalesOrderId must be a positive integer");
        }
        SalesOrderEntity salesOrderEntity = (SalesOrderEntity)this.salesOrderDAO.find(Long.valueOf(salesOrderId));
        if (salesOrderEntity == null) {
            throw new EntityNotFoundException("SalesOrder with id " + salesOrderId + " not found");
        }
        this.salesOrderDAO.delete(salesOrderEntity);
    }

    public SalesOrder getSalesOrderById(long SalesOrderId) {
        if (SalesOrderId <= 0L) {
            throw new IllegalArgumentException("SalesOrderId must be a positive integer");
        }
        SalesOrderEntity SalesOrderEntity2 = (SalesOrderEntity)this.salesOrderDAO.find(Long.valueOf(SalesOrderId));
        return this.toDTO(SalesOrderEntity2);
    }

    public List<SalesOrder> getSalesOrders() {
        List applicatiions = this.salesOrderDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countSalesOrders() {
        return this.salesOrderDAO.count();
    }

    public SalesOrder toDTO(SalesOrderEntity salesOrderEntity) {
        if (salesOrderEntity == null) {
            return null;
        }
        return new SalesOrder(salesOrderEntity.getId(), salesOrderEntity.getName(), salesOrderEntity.getDescription(), this.clientStorage.toDTO(salesOrderEntity.getClientEntity()));
    }

    public SalesOrderEntity toEntity(SalesOrder salesOrder) {
        if (salesOrder == null) {
            return null;
        }
        return new SalesOrderEntity(salesOrder.getId(), salesOrder.getName(), salesOrder.getDescription(), this.clientStorage.toEntity(salesOrder.getClient()));
    }
}

