/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.timetracker.dao.ActivityRecordDAO;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.RecordsAccessList;
import org.exoplatform.timetracker.entity.ActivityRecordEntity;
import org.exoplatform.timetracker.storage.ActivityStorage;
import org.exoplatform.timetracker.storage.ClientStorage;
import org.exoplatform.timetracker.storage.SalesOrderStorage;
import org.gatein.api.EntityNotFoundException;

public class ActivityRecordStorage {
    private final ActivityRecordDAO activityRecordDAO;
    private final ClientStorage clientStorage;
    private final ActivityStorage activityStorage;
    private final SalesOrderStorage salesOrderStorage;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public ActivityRecordStorage(ActivityRecordDAO activityRecordDAO, ClientStorage clientStorage, ActivityStorage activityStorage, SalesOrderStorage salesOrderStorage) {
        this.activityRecordDAO = activityRecordDAO;
        this.clientStorage = clientStorage;
        this.activityStorage = activityStorage;
        this.salesOrderStorage = salesOrderStorage;
    }

    public ActivityRecord createActivityRecord(ActivityRecord activityRecord) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        ActivityRecordEntity activityRecordEntity = this.toEntity(activityRecord);
        activityRecordEntity.setId(null);
        activityRecordEntity.setCreatedDate(new Date());
        activityRecordEntity.setActivityTime(this.formatter.parse(activityRecordEntity.getActivityDate()));
        activityRecordEntity = (ActivityRecordEntity)this.activityRecordDAO.create(activityRecordEntity);
        return this.toDTO(activityRecordEntity);
    }

    public ActivityRecord updateActivityRecord(ActivityRecord activityRecord) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        Long activityRecordId = activityRecord.getId();
        ActivityRecordEntity activityRecordEntity = (ActivityRecordEntity)this.activityRecordDAO.find(activityRecord.getId());
        if (activityRecordEntity == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + activityRecordId + " wasn't found");
        }
        activityRecordEntity = this.toEntity(activityRecord);
        activityRecordEntity = (ActivityRecordEntity)this.activityRecordDAO.update(activityRecordEntity);
        return this.toDTO(activityRecordEntity);
    }

    public void deleteActivityRecord(long activityRecordId) throws EntityNotFoundException {
        if (activityRecordId <= 0L) {
            throw new IllegalArgumentException("ActivityRecordId must be a positive integer");
        }
        ActivityRecordEntity activityRecordEntity = (ActivityRecordEntity)this.activityRecordDAO.find(Long.valueOf(activityRecordId));
        if (activityRecordEntity == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + activityRecordId + " not found");
        }
        this.activityRecordDAO.delete(activityRecordEntity);
    }

    public ActivityRecord getActivityRecordById(long ActivityRecordId) {
        if (ActivityRecordId <= 0L) {
            throw new IllegalArgumentException("ActivityRecordId must be a positive integer");
        }
        ActivityRecordEntity ActivityRecordEntity2 = (ActivityRecordEntity)this.activityRecordDAO.find(Long.valueOf(ActivityRecordId));
        return this.toDTO(ActivityRecordEntity2);
    }

    public List<ActivityRecord> getActivityRecords() {
        List applicatiions = this.activityRecordDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<ActivityRecord> getUserActivityRecords(String day, String userName) {
        List<ActivityRecordEntity> applicatiions = this.activityRecordDAO.getUserActivityRecordsList(day, userName);
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public RecordsAccessList getActivityRecordsList(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        List<ActivityRecordEntity> applicatiions = this.activityRecordDAO.getActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, offset, limit, sortBy, sortDesc);
        RecordsAccessList recordsAccessList = new RecordsAccessList();
        recordsAccessList.setActivityRecords(applicatiions.stream().map(this::toDTO).collect(Collectors.toList()));
        recordsAccessList.setSize(this.activityRecordDAO.countActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office));
        return recordsAccessList;
    }

    public ActivityRecord getLastActivityRecord(String userName) {
        return this.toDTO(this.activityRecordDAO.getLastActivityRecord(userName));
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        return this.activityRecordDAO.countActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office);
    }

    public ActivityRecord toDTO(ActivityRecordEntity activityRecordEntity) {
        if (activityRecordEntity == null) {
            return null;
        }
        return new ActivityRecord(activityRecordEntity.getId(), activityRecordEntity.getUserName(), activityRecordEntity.getActivityDate(), activityRecordEntity.getActivityTime(), activityRecordEntity.getDescription(), activityRecordEntity.getLocation(), activityRecordEntity.getOffice(), activityRecordEntity.getTime(), activityRecordEntity.getProjectVersion(), this.clientStorage.toDTO(activityRecordEntity.getClientEntity()), this.activityStorage.toDTO(activityRecordEntity.getActivityEntity()), this.salesOrderStorage.toDTO(activityRecordEntity.getSalesOrderEntity()), activityRecordEntity.getCreatedDate());
    }

    public ActivityRecordEntity toEntity(ActivityRecord activityRecord) {
        if (activityRecord == null) {
            return null;
        }
        return new ActivityRecordEntity(activityRecord.getId(), activityRecord.getUserName(), activityRecord.getActivityDate(), activityRecord.getActivityTime(), activityRecord.getDescription(), activityRecord.getLocation(), activityRecord.getOffice(), activityRecord.getTime().floatValue(), activityRecord.getProjectVersion(), this.clientStorage.toEntity(activityRecord.getClient()), this.activityStorage.toEntity(activityRecord.getActivity()), this.salesOrderStorage.toEntity(activityRecord.getSalesOrder()), activityRecord.getCreatedDate());
    }
}

