/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.Activity;
import org.exoplatform.timetracker.storage.ActivityStorage;

public class ActivityService {
    private static final Log LOG = ExoLogger.getLogger(ActivityService.class);
    private final ActivityStorage activitiestorage;

    public ActivityService(ActivityStorage activitiestorage) {
        this.activitiestorage = activitiestorage;
    }

    public Activity createActivity(Activity activity) throws Exception {
        if (activity == null) {
            throw new IllegalArgumentException("Activity is mandatory");
        }
        return this.activitiestorage.createActivity(activity);
    }

    public Activity updateActivity(Activity Activity2, String username) throws Exception {
        if (Activity2 == null) {
            throw new IllegalArgumentException("Activity is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ActivityId = Activity2.getId();
        if (ActivityId == null) {
            throw new EntityNotFoundException("Activity with null id wasn't found");
        }
        Activity storedActivity = this.activitiestorage.getActivityById(ActivityId);
        if (storedActivity == null) {
            throw new EntityNotFoundException("Activity with id " + ActivityId + " wasn't found");
        }
        return this.activitiestorage.updateActivity(Activity2);
    }

    public void deleteActivity(Long activityId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (activityId == null || activityId <= 0L) {
            throw new IllegalArgumentException("ActivityId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Activity storedActivity = this.activitiestorage.getActivityById(activityId);
        if (storedActivity == null) {
            throw new EntityNotFoundException("Activity with id " + activityId + " not found");
        }
        this.activitiestorage.deleteActivity(activityId);
    }

    public List<Activity> getActivitiesList() {
        return this.activitiestorage.getActivities();
    }

    public List<Activity> getActivitiesforUser(List<String> teams) {
        return this.activitiestorage.getActivitiesByTeams(teams);
    }
}

