/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.time.ZoneId;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.ActivityRecord;
import org.exoplatform.timetracker.dto.RecordsAccessList;
import org.exoplatform.timetracker.dto.Team;
import org.exoplatform.timetracker.storage.ActivityRecordStorage;

public class ActivityRecordService {
    private static final Log LOG = ExoLogger.getLogger(ActivityRecordService.class);
    private final ActivityRecordStorage activityRecordstorage;

    public ActivityRecordService(ActivityRecordStorage activityRecordstorage) {
        this.activityRecordstorage = activityRecordstorage;
    }

    public ActivityRecord createActivityRecord(ActivityRecord activityRecord) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        return this.activityRecordstorage.createActivityRecord(activityRecord);
    }

    public ActivityRecord updateActivityRecord(ActivityRecord activityRecord, String username) throws Exception {
        if (activityRecord == null) {
            throw new IllegalArgumentException("ActivityRecord is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ActivityRecordId = activityRecord.getId();
        if (ActivityRecordId == null) {
            throw new EntityNotFoundException("ActivityRecord with null id wasn't found");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(ActivityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + ActivityRecordId + " wasn't found");
        }
        return this.activityRecordstorage.updateActivityRecord(activityRecord);
    }

    public void deleteActivityRecord(Long activityRecordId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (activityRecordId == null || activityRecordId <= 0L) {
            throw new IllegalArgumentException("ActivityRecordId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        ActivityRecord storedActivityRecord = this.activityRecordstorage.getActivityRecordById(activityRecordId);
        if (storedActivityRecord == null) {
            throw new EntityNotFoundException("ActivityRecord with id " + activityRecordId + " not found");
        }
        this.activityRecordstorage.deleteActivityRecord(activityRecordId);
    }

    public List<ActivityRecord> getActivityRecords() {
        return this.activityRecordstorage.getActivityRecords();
    }

    public RecordsAccessList getActivityRecordsList(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office, int offset, int limit, String sortBy, boolean sortDesc) {
        return this.activityRecordstorage.getActivityRecordsList(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office, offset, limit, sortBy, sortDesc);
    }

    public ActivityRecord getLastActivityRecord(String userName) {
        return this.activityRecordstorage.getLastActivityRecord(userName);
    }

    public long countActivityRecords(String search, Long activity, Long type, Long subType, Long activityCode, Long subActivityCode, Long client, Long project, Long feature, String fromDate, String toDate, String userName, String location, String office) {
        return this.activityRecordstorage.countActivityRecords(search, activity, type, subType, activityCode, subActivityCode, client, project, feature, fromDate, toDate, userName, location, office);
    }

    public List<ActivityRecord> getUserActivityRecordsList(String day, String userName) {
        return this.activityRecordstorage.getUserActivityRecords(day, userName);
    }

    public String generateTSCode(List<Team> teams, ActivityRecord record) {
        String team = "";
        if (teams != null && teams.size() > 0) {
            team = teams.get(0).getName();
        }
        Object tsCode = String.valueOf(record.getActivityTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear());
        tsCode = (String)tsCode + "_" + record.getOffice();
        if (record.getActivity() != null && record.getActivity().getType() != null) {
            tsCode = (String)tsCode + "_" + record.getActivity().getType().getCode();
        }
        if (record.getActivity() != null && record.getActivity().getSubType() != null) {
            tsCode = (String)tsCode + "_" + record.getActivity().getSubType().getCode();
        }
        if (team.equals("Analysts") || team.equals("ITOP") || team.equals("Dev Squad")) {
            tsCode = (String)tsCode + this.getClient(record);
        } else if (team.equals("Architects") || team.equals("Designers")) {
            tsCode = (String)tsCode + this.getClient(record) + this.getProject(record) + this.getActivity(record) + this.geSubActivity(record);
        } else if (team.equals("Support")) {
            tsCode = (String)tsCode + this.getClient(record) + this.getActivity(record);
        } else if (team.equals("QA")) {
            tsCode = (String)tsCode + this.getProject(record) + this.getProject(record);
        }
        return tsCode;
    }

    String getProject(ActivityRecord record) {
        Object project = "";
        if (record.getActivity() != null && record.getActivity().getProject() != null) {
            project = "_" + record.getActivity().getProject().getCode();
        } else if (record.getProject() != null) {
            project = "_" + record.getProject().getCode();
        }
        return project;
    }

    String getClient(ActivityRecord record) {
        Object client = "";
        if (record.getActivity() != null && record.getActivity().getProject() != null && record.getActivity().getProject().getClient() != null) {
            client = "_" + record.getActivity().getProject().getClient().getCode();
        } else if (record.getClient() != null) {
            client = "_" + record.getClient().getCode();
        }
        return client;
    }

    String getActivity(ActivityRecord record) {
        Object activity = "";
        if (record.getActivity() != null && record.getActivity().getActivityCode() != null) {
            activity = "_" + record.getActivity().getActivityCode().getCode();
        }
        return activity;
    }

    String geSubActivity(ActivityRecord record) {
        Object subActivity = "";
        if (record.getActivity() != null && record.getActivity().getSubActivityCode() != null) {
            subActivity = "_" + record.getActivity().getSubActivityCode().getCode();
        }
        return subActivity;
    }
}

