/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.timetracker.dao.ClientDAO;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.entity.ClientEntity;
import org.exoplatform.timetracker.storage.SalesOrderStorage;
import org.gatein.api.EntityNotFoundException;

public class ClientStorage {
    private final ClientDAO clientDAO;

    public ClientStorage(ClientDAO clientDAO) {
        this.clientDAO = clientDAO;
    }

    public Client createClient(Client client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Client is mandatory");
        }
        ClientEntity clientEntity = this.toEntity(client);
        client.setId(null);
        clientEntity = (ClientEntity)this.clientDAO.create(clientEntity);
        return this.toDTO(clientEntity);
    }

    public Client updateClient(Client client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Client is mandatory");
        }
        Long clientId = client.getId();
        ClientEntity clientEntity = (ClientEntity)this.clientDAO.find(client.getId());
        if (clientEntity == null) {
            throw new EntityNotFoundException("Client with id " + clientId + " wasn't found");
        }
        clientEntity = this.toEntity(client);
        clientEntity = (ClientEntity)this.clientDAO.update(clientEntity);
        return this.toDTO(clientEntity);
    }

    public void deleteClient(long clientId) throws EntityNotFoundException {
        if (clientId <= 0L) {
            throw new IllegalArgumentException("ClientId must be a positive integer");
        }
        ClientEntity clientEntity = (ClientEntity)this.clientDAO.find(Long.valueOf(clientId));
        if (clientEntity == null) {
            throw new EntityNotFoundException("Client with id " + clientId + " not found");
        }
        this.clientDAO.delete(clientEntity);
    }

    public Client getClientById(long ClientId) {
        if (ClientId <= 0L) {
            throw new IllegalArgumentException("ClientId must be a positive integer");
        }
        ClientEntity ClientEntity2 = (ClientEntity)this.clientDAO.find(Long.valueOf(ClientId));
        return this.toDTO(ClientEntity2);
    }

    public List<Client> getClients() {
        List applicatiions = this.clientDAO.findAll();
        return applicatiions.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public long countClients() {
        return this.clientDAO.count();
    }

    public Client toDTO(ClientEntity clientEntity) {
        if (clientEntity == null) {
            return null;
        }
        SalesOrderStorage salesOrderStorage = (SalesOrderStorage)CommonsUtils.getService(SalesOrderStorage.class);
        return new Client(clientEntity.getId(), clientEntity.getCode(), clientEntity.getLabel(), salesOrderStorage.getSalesOrderByClienId(clientEntity.getId()));
    }

    public ClientEntity toEntity(Client client) {
        if (client == null) {
            return null;
        }
        return new ClientEntity(client.getId(), client.getCode(), client.getLabel());
    }
}

