/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.storage.ClientStorage;

public class ClientService {
    private static final Log LOG = ExoLogger.getLogger(ClientService.class);
    private final ClientStorage clientStorage;

    public ClientService(ClientStorage clientStorage) {
        this.clientStorage = clientStorage;
    }

    public Client createClient(Client client) throws Exception {
        if (client == null) {
            throw new IllegalArgumentException("Client is mandatory");
        }
        return this.clientStorage.createClient(client);
    }

    public Client updateClient(Client Client2, String username) throws Exception {
        if (Client2 == null) {
            throw new IllegalArgumentException("Client is mandatory");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Long ClientId = Client2.getId();
        if (ClientId == null) {
            throw new EntityNotFoundException("Client with null id wasn't found");
        }
        Client storedClient = this.clientStorage.getClientById(ClientId);
        if (storedClient == null) {
            throw new EntityNotFoundException("Client with id " + ClientId + " wasn't found");
        }
        return this.clientStorage.updateClient(Client2);
    }

    public void deleteClient(Long clientId, String username) throws EntityNotFoundException, IllegalAccessException {
        if (clientId == null || clientId <= 0L) {
            throw new IllegalArgumentException("ClientId must be a positive integer");
        }
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        Client storedClient = this.clientStorage.getClientById(clientId);
        if (storedClient == null) {
            throw new EntityNotFoundException("Client with id " + clientId + " not found");
        }
        this.clientStorage.deleteClient(clientId);
    }

    public List<Client> getClientsList() {
        return this.clientStorage.getClients();
    }
}

