/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.service.ClientService;

@Path(value="timetracker/clientsmgn")
@RolesAllowed(value={"users"})
@Api(value="/timetracker", description="Manage and access Clients")
public class ClientsManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ClientsManagementREST.class);
    private final String portalContainerName = "portal";
    private final ClientService clientService;

    public ClientsManagementREST(ClientService clientService, PortalContainer container) {
        this.clientService = clientService;
    }

    @GET
    @Path(value="client")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves all available subresources of current endpoint", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getClients() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.clientService.getClientsList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Clients", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="client")
    @RolesAllowed(value={"time-tracking-managers"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates a new Client", httpMethod="POST", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createClient(@ApiParam(value="Client to save", required=true) Client client) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.clientService.createClient(client);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Client", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-client parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="client")
    @RolesAllowed(value={"time-tracking-managers"})
    @ApiOperation(value="Updates an existing Client identified by its id", httpMethod="PUT", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateClient(@ApiParam(value="Client to update", required=true) Client client) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.clientService.updateClient(client, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Client", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-client parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="client/{clientId}")
    @RolesAllowed(value={"time-tracking-managers"})
    @ApiOperation(value="Deletes an existing Client identified by its id", httpMethod="DELETE", response=Response.class, notes="empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteClient(@ApiParam(value="Client technical id to delete", required=true) @PathParam(value="clientId") Long clientId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.clientService.deleteClient(clientId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Client", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-client parameters=\"user_social_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

