/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.dto.Project;
import org.exoplatform.timetracker.service.ClientService;
import org.exoplatform.timetracker.service.ProjectService;

public class ProjectServiceTest
extends TestCase {
    ProjectService projectService;
    ClientService clientService;
    private PortalContainer container;
    List<Project> tearDownProjects = new ArrayList<Project>();

    protected void setUp() throws Exception {
        super.setUp();
        this.container = PortalContainer.getInstance();
        this.projectService = (ProjectService)CommonsUtils.getService(ProjectService.class);
        this.clientService = (ClientService)CommonsUtils.getService(ClientService.class);
        this.begin();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (Project project : this.tearDownProjects) {
            this.projectService.deleteProject(project.getId(), "root");
        }
        this.end();
    }

    private void begin() {
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    private void end() {
        RequestLifeCycle.end();
    }

    public void testCreateProject() {
        Project project = null;
        try {
            try {
                project = this.projectService.createProject(project);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ProjectServiceTest.assertNull(project);
            project = this.createProject(1L).get(0);
            ProjectServiceTest.assertNotNull((Object)project);
            ProjectServiceTest.assertEquals((String)"PROJ0", (String)project.getCode());
        }
        catch (Exception e) {
            ProjectServiceTest.fail((String)"Failed to create a project");
        }
    }

    public void testUpdateProject() {
        try {
            Project project = null;
            try {
                project = this.projectService.updateProject(project, "root");
            }
            catch (Exception exception) {
                // empty catch block
            }
            project = new Project(null, "PROJX", "Project not saved yet", null);
            try {
                project = this.projectService.updateProject(project, "root");
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            project = new Project(Long.valueOf(5L), "PROJX", "Project not saved yet", null);
            try {
                project = this.projectService.updateProject(project, "root");
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            try {
                project = this.createProject(1L).get(0);
            }
            catch (Exception e) {
                ProjectServiceTest.fail((String)"Exception when create a project");
            }
            project.setCode("Updated Code");
            try {
                project = this.projectService.updateProject(project, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            project = this.projectService.updateProject(project, "root");
            ProjectServiceTest.assertEquals((String)"Updated Code", (String)project.getCode());
        }
        catch (Exception e) {
            ProjectServiceTest.fail((String)("Problem running testUpdateProject : " + e.getMessage()));
        }
    }

    public void testDeleteProject() {
        try {
            try {
                this.projectService.deleteProject(Long.valueOf(-1L), "root");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.projectService.deleteProject(null, "root");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.projectService.deleteProject(Long.valueOf(1L), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.projectService.deleteProject(Long.valueOf(10L), "root");
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            List<Project> projects = this.createProject(3L);
            ProjectServiceTest.assertEquals((int)3, (int)this.projectService.getProjectsList().size());
            this.tearDownProjects.remove(projects.get(0));
            this.projectService.deleteProject(projects.get(0).getId(), "root");
            ProjectServiceTest.assertEquals((int)2, (int)this.projectService.getProjectsList().size());
        }
        catch (Exception e) {
            ProjectServiceTest.fail((String)("Problem running testDeleteProject : " + e.getMessage()));
        }
    }

    public void testGetProjectsList() {
    }

    private List<Project> createProject(long index) throws Exception {
        ArrayList<Project> projects = new ArrayList<Project>();
        Client client = new Client(null, "code", "label");
        client = this.clientService.createClient(client);
        int i = 0;
        while ((long)i < index) {
            Project project = new Project(null, "PROJ" + i, "Project Number " + i, client);
            project = this.projectService.createProject(project);
            projects.add(project);
            this.tearDownProjects.add(project);
            ++i;
        }
        return projects;
    }
}

