/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.io.Serializable;
import junit.framework.TestCase;
import org.exoplatform.timetracker.dao.FilterDAO;
import org.exoplatform.timetracker.dao.FilterFieldDAO;
import org.exoplatform.timetracker.dto.Filter;
import org.exoplatform.timetracker.dto.FilterField;
import org.exoplatform.timetracker.entity.FilterEntity;
import org.exoplatform.timetracker.entity.FilterFieldEntity;
import org.exoplatform.timetracker.storage.FilterStorage;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FilterStorageTest
extends TestCase {
    private FilterDAO filterDAO;
    private FilterFieldDAO filterFieldDAO;
    private FilterStorage filterStorage;

    @Before
    public void setUp() throws Exception {
        this.filterDAO = (FilterDAO)Mockito.mock(FilterDAO.class);
        this.filterFieldDAO = (FilterFieldDAO)Mockito.mock(FilterFieldDAO.class);
        this.filterStorage = new FilterStorage(this.filterDAO, this.filterFieldDAO);
    }

    public void testCreateFilter() throws Exception {
        Filter newFilterCreated = null;
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(1L), "testName", "root");
        Mockito.when((Object)((FilterEntity)this.filterDAO.create((Object)filterEntity))).thenReturn((Object)filterEntity);
        newFilterCreated = this.filterStorage.createFilter(filter);
        FilterStorageTest.assertNotNull((Object)newFilterCreated);
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).create((Object)((FilterEntity)Mockito.any()));
    }

    public void testUpdateFilter() throws Exception {
        Filter filterUpdated = null;
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(1L), "testName", "root");
        FilterEntity filterEntityUpdated = new FilterEntity(Long.valueOf(1L), "testNameUpdated", "root");
        Mockito.when((Object)((FilterEntity)this.filterDAO.find((Serializable)filter.getId()))).thenReturn((Object)filterEntity);
        Mockito.when((Object)((FilterEntity)this.filterDAO.update((Object)filterEntity))).thenReturn((Object)filterEntityUpdated);
        filterUpdated = this.filterStorage.updateFilter(filter);
        FilterStorageTest.assertNotNull((Object)filterUpdated);
        FilterStorageTest.assertEquals((String)filterUpdated.getName(), (String)"testNameUpdated");
        FilterStorageTest.assertEquals((long)filterUpdated.getId(), (long)1L);
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).update((Object)((FilterEntity)Mockito.any()));
    }

    public void testDeleteFilter() {
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(1L), "testName", "root");
        Mockito.when((Object)((FilterEntity)this.filterDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)filterEntity);
        ((FilterDAO)Mockito.doNothing().when((Object)this.filterDAO)).delete((Object)filterEntity);
        this.filterStorage.deleteFilter(1L);
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)((FilterEntity)Mockito.any()));
    }

    public void testGetFilters() {
        Filter filter = null;
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(1L), "testName", "root");
        Mockito.when((Object)((FilterEntity)this.filterDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)filterEntity);
        filter = this.filterStorage.getFilterById(1L);
        ((FilterDAO)Mockito.verify((Object)this.filterDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        FilterStorageTest.assertNotNull((Object)filter);
    }

    public void testCreateFilterField() throws Exception {
        FilterField filterFieldCreated = null;
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(1L), "testName", "root");
        Filter filter = new Filter(Long.valueOf(1L), "testName", "root");
        FilterField filterField = new FilterField(Long.valueOf(1L), "test", new String[]{"test"}, filter);
        FilterFieldEntity filterFieldEntity = new FilterFieldEntity(Long.valueOf(1L), "testName", "testValue", filterEntity);
        Mockito.when((Object)((FilterFieldEntity)this.filterFieldDAO.create((Object)((FilterFieldEntity)Mockito.any())))).thenReturn((Object)filterFieldEntity);
        filterFieldCreated = this.filterStorage.createFilterField(filterField);
        FilterStorageTest.assertNotNull((Object)filterFieldCreated);
        ((FilterFieldDAO)Mockito.verify((Object)this.filterFieldDAO, (VerificationMode)Mockito.times((int)1))).create((Object)((FilterFieldEntity)Mockito.any()));
    }

    public void testDeleteFilterField() {
        FilterEntity filterEntity = new FilterEntity(Long.valueOf(2L), "testName", "root");
        FilterFieldEntity filterFieldEntity = new FilterFieldEntity(Long.valueOf(1L), "testName", "testValue", filterEntity);
        Mockito.when((Object)((FilterFieldEntity)this.filterFieldDAO.find((Serializable)Long.valueOf(Matchers.anyLong())))).thenReturn((Object)filterFieldEntity);
        ((FilterFieldDAO)Mockito.doNothing().when((Object)this.filterFieldDAO)).delete((Object)filterFieldEntity);
        this.filterStorage.deleteFilterField(1L);
        ((FilterFieldDAO)Mockito.verify((Object)this.filterFieldDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        ((FilterFieldDAO)Mockito.verify((Object)this.filterFieldDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)((FilterFieldEntity)Mockito.any()));
    }
}

