/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.EntityExistsException;
import jakarta.persistence.EntityNotFoundException;
import java.text.SimpleDateFormat;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.timetracker.dto.Location;
import org.exoplatform.timetracker.dto.Office;
import org.exoplatform.timetracker.dto.TimeTrackerSetting;
import org.exoplatform.timetracker.dto.WorkTime;
import org.exoplatform.timetracker.service.TimeTrackerSettingsService;

@Path(value="timetracker/settings")
@RolesAllowed(value={"users"})
@Tag(name="/timetracker", description="Manage and access Codes")
public class SettingsManagementREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SettingsManagementREST.class);
    private final String portalContainerName = "portal";
    private final TimeTrackerSettingsService timeTrackerSettingsService;
    private final String DATE_FORMAT = "yyyy-MM-dd";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public SettingsManagementREST(TimeTrackerSettingsService timeTrackerSettingsService, PortalContainer container) {
        this.timeTrackerSettingsService = timeTrackerSettingsService;
    }

    @GET
    @Path(value="worktime")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getWorkTimes() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.timeTrackerSettingsService.getWorkTimesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting WorkTimes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="worktime")
    @RolesAllowed(value={"time-tracking-managers"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new WorkTime", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createWorkTime(@Parameter(description="WorkTime to save", required=true) WorkTime workTime) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            if (!StringUtils.isNotEmpty((CharSequence)workTime.getFromDate())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            workTime.setFrom(this.formatter.parse(workTime.getFromDate()));
            if (!StringUtils.isNotEmpty((CharSequence)workTime.getToDate())) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            workTime.setTo(this.formatter.parse(workTime.getToDate()));
            this.timeTrackerSettingsService.createWorkTime(workTime);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating WorkTime", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="worktime")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Updates an existing WorkTime identified by its id", method="PUT", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateWorkTime(@Parameter(description="WorkTime to update", required=true) WorkTime workTime) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.updateWorkTime(workTime, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating WorkTime", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=update-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="workTime/{workTimeId}")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Deletes an existing WorkTime identified by its id", method="DELETE", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteWorkTime(@Parameter(description="WorkTime technical id to delete", required=true) @PathParam(value="workTimeId") Long workTimeId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.deleteWorkTime(workTimeId, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting WorkTime", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="location")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getLocations() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.timeTrackerSettingsService.getLocationsList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Locations", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="location")
    @RolesAllowed(value={"time-tracking-managers"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new Location", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createLocation(@Parameter(description="Location to save", required=true) Location location) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.createLocation(location);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Location", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-sub-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="location")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Updates an existing Location identified by its id", method="PUT", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateLocation(@Parameter(description="Location to update", required=true) Location location) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.updateLocation(location, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Location", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=edit-sub-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="location/{code}")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Deletes an existing Location identified by its id", method="DELETE", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteLocation(@Parameter(description="Location technical id to delete", required=true) @PathParam(value="code") String code) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.deleteLocation(code, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Location", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-sub-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="office")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available subresources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getOffices() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok(this.timeTrackerSettingsService.getOfficesList()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting Offices", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="office")
    @RolesAllowed(value={"time-tracking-managers"})
    @Consumes(value={"application/json"})
    @Operation(summary="Creates a new Office", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createOffice(@Parameter(description="Office to save", required=true) Office office) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.createOffice(office);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating Office", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-office parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @PUT
    @Path(value="office")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Updates an existing Office identified by its id", method="PUT", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateOffice(@Parameter(description="Office to update", required=true) Office office) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.updateOffice(office, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while updating Office", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=edit-office parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="office/{code}")
    @RolesAllowed(value={"time-tracking-managers"})
    @Operation(summary="Deletes an existing Office identified by its id", method="DELETE", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteOffice(@Parameter(description="Office technical id to delete", required=true) @PathParam(value="code") String code) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.deleteOffice(code, this.getCurrentUserName());
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)e);
            return Response.status((int)401).build();
        }
        catch (EntityNotFoundException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while deleting Office", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=delete-office parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    @GET
    @Path(value="other")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves all available resources of current endpoint", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getOtherSettings() {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            return Response.ok((Object)this.timeTrackerSettingsService.getSettings()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while getting WorkTimes", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @PATCH
    @Path(value="others")
    @RolesAllowed(value={"time-tracking-managers"})
    @Consumes(value={"application/json"})
    @Operation(summary="update settings", method="POST", description="empty response")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveSettings(@Parameter(description="WorkTime to save", required=true) TimeTrackerSetting ttSettings) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.timeTrackerSettingsService.saveSettings(ttSettings);
        }
        catch (EntityExistsException e) {
            LOG.warn((Object)e);
            return Response.serverError().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unknown error occurred while creating WorkTime", (Throwable)e);
            return Response.serverError().build();
        }
        LOG.info("service=time-tracker operation=add-activity-code parameters=\"user_id:{}\"", new Object[]{sourceIdentity.getId()});
        return Response.noContent().build();
    }

    private String getCurrentUserName() {
        ConversationState state = ConversationState.getCurrent();
        return state == null || state.getIdentity() == null ? null : state.getIdentity().getUserId();
    }
}

