/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.timetracker.dao.FeatureDAO;
import org.exoplatform.timetracker.dto.Feature;
import org.exoplatform.timetracker.entity.FeatureEntity;
import org.exoplatform.timetracker.storage.FeatureStorage;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FeatureStorageTest
extends TestCase {
    private FeatureDAO featureDAO;
    private FeatureStorage featureStorage;

    @Before
    public void setUp() throws Exception {
        this.featureDAO = (FeatureDAO)Mockito.mock(FeatureDAO.class);
        this.featureStorage = new FeatureStorage(this.featureDAO);
    }

    public void testCreateFeature() throws Exception {
        FeatureEntity featureEntity = new FeatureEntity(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo");
        Feature newFeature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Mockito.when((Object)((FeatureEntity)this.featureDAO.create((Object)featureEntity))).thenReturn((Object)featureEntity);
        Feature feature = null;
        feature = this.featureStorage.createFeature(newFeature);
        FeatureStorageTest.assertNotNull((Object)feature);
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).create((Object)((FeatureEntity)Mockito.any()));
    }

    public void testUpdateFeature() throws Exception {
        FeatureEntity featureEntity = new FeatureEntity(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo");
        FeatureEntity featureEntityUpdated = new FeatureEntity(Long.valueOf(1L), "testCodeUpdate", "testLabelUpdate", "testSpecUpdate", "testExoUpdate");
        Feature feature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Feature newFeatureUpdated = null;
        Mockito.when((Object)((FeatureEntity)this.featureDAO.find((Serializable)feature.getId()))).thenReturn((Object)featureEntity);
        Mockito.when((Object)((FeatureEntity)this.featureDAO.update((Object)featureEntity))).thenReturn((Object)featureEntityUpdated);
        newFeatureUpdated = this.featureStorage.updateFeature(feature);
        FeatureStorageTest.assertEquals((long)newFeatureUpdated.getId(), (long)1L);
        FeatureStorageTest.assertEquals((String)newFeatureUpdated.getLabel(), (String)"testLabelUpdate");
        FeatureStorageTest.assertEquals((String)newFeatureUpdated.getSpec(), (String)"testSpecUpdate");
        FeatureStorageTest.assertEquals((String)newFeatureUpdated.getExo(), (String)"testExoUpdate");
        FeatureStorageTest.assertEquals((String)newFeatureUpdated.getCode(), (String)"testCodeUpdate");
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).update((Object)((FeatureEntity)Mockito.any()));
    }

    public void testDeleteFeature() {
        FeatureEntity featureEntity = new FeatureEntity(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo");
        Feature feature = new Feature(Long.valueOf(1L), "testCode", "testLabel", "testSpec", "testExo", null);
        Mockito.when((Object)((FeatureEntity)this.featureDAO.find((Serializable)feature.getId()))).thenReturn((Object)featureEntity);
        ((FeatureDAO)Mockito.doNothing().when((Object)this.featureDAO)).delete((Object)featureEntity);
        this.featureStorage.deleteFeature(feature.getId().longValue());
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)((FeatureEntity)Mockito.any()));
    }

    public void testGetFeatures() {
        FeatureEntity featureEntity = new FeatureEntity(Long.valueOf(1L), "testCode1", "testLabel1", "testSpec1", "testExo1");
        FeatureEntity featureEntity1 = new FeatureEntity(Long.valueOf(2L), "testCode2", "testLabel2", "testSpec2", "testExo2");
        FeatureEntity featureEntity2 = new FeatureEntity(Long.valueOf(3L), "testCode3", "testLabel3", "testSpec3", "testExo3");
        FeatureEntity featureEntity3 = new FeatureEntity(Long.valueOf(4L), "testCode4", "testLabel4", "testSpec4", "testExo4");
        ArrayList<FeatureEntity> features = new ArrayList<FeatureEntity>();
        features.add(featureEntity);
        features.add(featureEntity1);
        features.add(featureEntity2);
        features.add(featureEntity3);
        Mockito.when((Object)this.featureDAO.findAll()).thenReturn(features);
        List clientsList = this.featureStorage.getFeatures();
        FeatureStorageTest.assertEquals((int)4, (int)clientsList.size());
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).findAll();
    }

    public void testGetFeatureById() {
        FeatureEntity featureEntity = new FeatureEntity(Long.valueOf(1L), "testCode1", "testLabel1", "testSpec1", "testExo1");
        Mockito.when((Object)((FeatureEntity)this.featureDAO.find((Serializable)Long.valueOf(Mockito.eq((long)1L))))).thenReturn((Object)featureEntity);
        Feature notExistingFeature = this.featureStorage.getFeatureById(2L);
        FeatureStorageTest.assertNull((Object)notExistingFeature);
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(Matchers.anyLong()));
        Feature feature = this.featureStorage.getFeatureById(1L);
        FeatureStorageTest.assertNotNull((Object)feature);
        ((FeatureDAO)Mockito.verify((Object)this.featureDAO, (VerificationMode)Mockito.times((int)2))).find((Serializable)Long.valueOf(Matchers.anyLong()));
    }
}

