/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.service.ClientService;
import org.exoplatform.timetracker.storage.ClientStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClientServiceTest {
    private ClientService clientService;
    private ClientStorage clientStorage;

    @Before
    public void setUp() throws Exception {
        this.clientStorage = (ClientStorage)Mockito.mock(ClientStorage.class);
        this.clientService = new ClientService(this.clientStorage);
    }

    @Test
    public void testGetClientsList() {
        Client clientDto = new Client(Long.valueOf(1L), "code", "label");
        Client clientDto1 = new Client(Long.valueOf(2L), "code1", "label1");
        Client clientDto2 = new Client(Long.valueOf(3L), "code2", "label2");
        ArrayList<Client> clients = new ArrayList<Client>();
        clients.add(clientDto);
        clients.add(clientDto1);
        clients.add(clientDto2);
        Mockito.when((Object)this.clientStorage.getClients()).thenReturn(clients);
        List clientsList = this.clientService.getClientsList();
        Assert.assertEquals((long)3L, (long)clientsList.size());
        ((ClientStorage)Mockito.verify((Object)this.clientStorage, (VerificationMode)Mockito.times((int)1))).getClients();
    }
}

