/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.timetracker.entity.FilterEntity;

public class FilterDAO
extends GenericDAOJPAImpl<FilterEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(FilterDAO.class);

    public List<FilterEntity> getFiltersByUserName(String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("FilterEntity.getFiltersByUserName", FilterEntity.class).setParameter("userName", (Object)userName);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return new ArrayList<FilterEntity>();
        }
        catch (Exception e) {
            LOG.error("Error occurred when trying to get list of fields by filter {}", new Object[]{userName, e});
            return new ArrayList<FilterEntity>();
        }
    }
}

