/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.timetracker.dto.ActivityCode;
import org.exoplatform.timetracker.service.CodesService;
import org.exoplatform.timetracker.storage.CodesStorage;
import org.junit.Before;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CodesServiceTest
extends TestCase {
    private CodesService codesService;
    private CodesStorage codesStorage;

    @Before
    public void setUp() throws Exception {
        this.codesStorage = (CodesStorage)Mockito.mock(CodesStorage.class);
        this.codesService = new CodesService(this.codesStorage);
    }

    public void testCreateActivityCode() throws Exception {
        ActivityCode activityCode = null;
        ActivityCode newActivityCode = new ActivityCode(Long.valueOf(1L), "testCode", "testLabel");
        Mockito.when((Object)this.codesStorage.createActivityCode((ActivityCode)Matchers.any())).thenReturn((Object)newActivityCode);
        activityCode = this.codesService.createActivityCode(newActivityCode);
        CodesServiceTest.assertNotNull((Object)activityCode);
        ((CodesStorage)Mockito.verify((Object)this.codesStorage, (VerificationMode)Mockito.times((int)1))).createActivityCode((ActivityCode)Matchers.any());
    }

    public void testUpdateActivityCode() throws Exception {
        ActivityCode activityCode = new ActivityCode(Long.valueOf(1L), "testCode", "testLabel");
        ActivityCode activityCodeUpdated = new ActivityCode(Long.valueOf(1L), "testCodeUpdated", "testLabelUpdated");
        Mockito.when((Object)this.codesStorage.getActivityCodeById(Mockito.anyLong())).thenReturn((Object)activityCode);
        Mockito.when((Object)this.codesStorage.updateActivityCode(activityCode)).thenReturn((Object)activityCodeUpdated);
        activityCodeUpdated = this.codesService.updateActivityCode(activityCode, "root");
        CodesServiceTest.assertEquals((String)activityCodeUpdated.getCode(), (String)"testCodeUpdated");
        CodesServiceTest.assertEquals((String)activityCodeUpdated.getLabel(), (String)"testLabelUpdated");
        CodesServiceTest.assertEquals((long)activityCodeUpdated.getId(), (long)1L);
    }

    public void testDeleteActivityCode() throws Exception {
        ActivityCode activityCode = new ActivityCode(Long.valueOf(1L), "testCode", "testLabel");
        ((CodesStorage)Mockito.doNothing().when((Object)this.codesStorage)).deleteActivityCode(activityCode.getId().longValue());
        Mockito.when((Object)this.codesStorage.getActivityCodeById(activityCode.getId().longValue())).thenReturn((Object)activityCode);
        this.codesService.deleteActivityCode(activityCode.getId(), "root");
        ((CodesStorage)Mockito.verify((Object)this.codesStorage, (VerificationMode)Mockito.times((int)1))).deleteActivityCode(Mockito.anyLong());
    }

    public void testGetActivityCodesList() {
        ActivityCode activityCode = new ActivityCode(Long.valueOf(1L), "testCode", "testLabel");
        ActivityCode activityCode1 = new ActivityCode(Long.valueOf(2L), "testCode1", "testLabel1");
        ActivityCode activityCode2 = new ActivityCode(Long.valueOf(3L), "testCode2", "testLabel2");
        ActivityCode activityCode3 = new ActivityCode(Long.valueOf(4L), "testCode3", "testLabel3");
        ArrayList<ActivityCode> activityCodes = new ArrayList<ActivityCode>();
        activityCodes.add(activityCode);
        activityCodes.add(activityCode1);
        activityCodes.add(activityCode2);
        activityCodes.add(activityCode3);
        Mockito.when((Object)this.codesStorage.getActivityCodes()).thenReturn(activityCodes);
        List activityCodeList = this.codesService.getActivityCodesList();
        CodesServiceTest.assertEquals((int)4, (int)activityCodeList.size());
        ((CodesStorage)Mockito.verify((Object)this.codesStorage, (VerificationMode)Mockito.times((int)1))).getActivityCodes();
    }
}

