/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.timetracker.dao.ClientDAO;
import org.exoplatform.timetracker.dto.Client;
import org.exoplatform.timetracker.entity.ClientEntity;
import org.exoplatform.timetracker.storage.ClientStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ClientStorageTest {
    private ClientDAO clientDAO;
    private ClientStorage clientStorage;

    @Before
    public void setUp() {
        this.clientDAO = (ClientDAO)Mockito.mock(ClientDAO.class);
        this.clientStorage = new ClientStorage(this.clientDAO);
        PortalContainer container = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    @After
    public void tearDown() {
        RequestLifeCycle.end();
    }

    @Test
    public void testGetClientById() {
        ClientEntity clientEntity = new ClientEntity(Long.valueOf(2L), "code", "label");
        Mockito.when((Object)((ClientEntity)this.clientDAO.find((Serializable)Long.valueOf(ArgumentMatchers.eq((long)2L))))).thenReturn((Object)clientEntity);
        Client notExistingClient = this.clientStorage.getClientById(1L);
        Assert.assertNull((Object)notExistingClient);
        ((ClientDAO)Mockito.verify((Object)this.clientDAO, (VerificationMode)Mockito.times((int)1))).find((Serializable)Long.valueOf(ArgumentMatchers.anyLong()));
        Client client = this.clientStorage.getClientById(2L);
        Assert.assertNotNull((Object)client);
        ((ClientDAO)Mockito.verify((Object)this.clientDAO, (VerificationMode)Mockito.times((int)2))).find((Serializable)Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testGetClients() {
        ClientEntity clientEntity = new ClientEntity(Long.valueOf(2L), "code", "label");
        ClientEntity clientEntity1 = new ClientEntity(Long.valueOf(2L), "code", "label");
        ClientEntity clientEntity2 = new ClientEntity(Long.valueOf(2L), "code", "label");
        ClientEntity clientEntity3 = new ClientEntity(Long.valueOf(2L), "code", "label");
        ArrayList<ClientEntity> clients = new ArrayList<ClientEntity>();
        clients.add(clientEntity);
        clients.add(clientEntity1);
        clients.add(clientEntity2);
        clients.add(clientEntity3);
        Mockito.when((Object)this.clientDAO.findAll()).thenReturn(clients);
        List clientsList = this.clientStorage.getClients();
        Assert.assertEquals((long)4L, (long)clientsList.size());
        ((ClientDAO)Mockito.verify((Object)this.clientDAO, (VerificationMode)Mockito.times((int)1))).findAll();
    }
}

