/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.timetracker.service;

import jakarta.persistence.EntityNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.timetracker.dto.Location;
import org.exoplatform.timetracker.dto.Office;
import org.exoplatform.timetracker.dto.TimeTrackerSetting;
import org.exoplatform.timetracker.dto.WorkTime;
import org.exoplatform.timetracker.storage.SettingsStorage;
import org.exoplatform.ws.frameworks.json.JsonGenerator;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.JsonParser;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.impl.ObjectBuilder;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class TimeTrackerSettingsService {
    private final SettingsStorage settingsStorage;
    private final SettingService settingService;
    private TimeTrackerSetting configuredTimeTrackerSetting;
    public static final String TIME_TRACKER_SCOPE_NAME = "ADDONS_TIME_TRACKER_SCOPE";
    public static final String TIME_TRACKER_CONTEXT_NAME = "ADDONS_TIME_TRACKER_CONTEXT";
    public static final Context TIME_TRACKER_CONTEXT = Context.GLOBAL.id("ADDONS_TIME_TRACKER_CONTEXT");
    public static final Scope TIME_TRACKER_SCOPE = Scope.APPLICATION.id("ADDONS_TIME_TRACKER_SCOPE");
    public static final String TIME_TRACKER_SETTINGS_KEY_NAME = "TIME_TRACKER_SETTINGS";
    public static final JsonParser JSON_PARSER = new JsonParserImpl();
    public static final JsonGenerator JSON_GENERATOR = new JsonGeneratorImpl();

    public TimeTrackerSettingsService(SettingsStorage settingsStorage, SettingService settingService) {
        this.settingsStorage = settingsStorage;
        this.settingService = settingService;
    }

    public WorkTime createWorkTime(WorkTime workTime) throws Exception {
        return this.settingsStorage.createWorkTime(workTime);
    }

    public WorkTime updateWorkTime(WorkTime workTime, String username) throws Exception {
        return this.settingsStorage.updateWorkTime(workTime);
    }

    public void deleteWorkTime(Long workTimeId, String username) throws EntityNotFoundException, IllegalAccessException {
        this.settingsStorage.deleteWorkTime(workTimeId);
    }

    public List<WorkTime> getWorkTimesList() {
        return this.settingsStorage.getWorkTimes();
    }

    public Location createLocation(Location location) throws Exception {
        return this.settingsStorage.createLocation(location);
    }

    public Location updateLocation(Location Location2, String username) throws Exception {
        return this.settingsStorage.updateLocation(Location2);
    }

    public void deleteLocation(String code, String username) throws EntityNotFoundException, IllegalAccessException {
        this.settingsStorage.deleteLocation(code);
    }

    public List<Location> getLocationsList() {
        return this.settingsStorage.getLocations();
    }

    public Office createOffice(Office office) throws Exception {
        return this.settingsStorage.createOffice(office);
    }

    public Office updateOffice(Office office, String username) throws Exception {
        return this.settingsStorage.updateOffice(office);
    }

    public void deleteOffice(String code, String username) throws EntityNotFoundException, IllegalAccessException {
        this.settingsStorage.deleteOffice(code);
    }

    public List<Office> getOfficesList() {
        return this.settingsStorage.getOffices();
    }

    public TimeTrackerSetting getSettings() {
        if (this.configuredTimeTrackerSetting != null) {
            return this.configuredTimeTrackerSetting.clone();
        }
        SettingValue settingsValue = this.settingService.get(TIME_TRACKER_CONTEXT, TIME_TRACKER_SCOPE, TIME_TRACKER_SETTINGS_KEY_NAME);
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        TimeTrackerSetting timeTrackerSetting = null;
        timeTrackerSetting = settingsValueString == null ? new TimeTrackerSetting() : TimeTrackerSettingsService.fromJsonString(settingsValueString, TimeTrackerSetting.class);
        this.configuredTimeTrackerSetting = timeTrackerSetting;
        return this.configuredTimeTrackerSetting;
    }

    public void saveSettings(TimeTrackerSetting timeTrackerSetting) throws Exception {
        if (timeTrackerSetting == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        String settingsString = TimeTrackerSettingsService.toJsonString(timeTrackerSetting);
        this.settingService.set(TIME_TRACKER_CONTEXT, TIME_TRACKER_SCOPE, TIME_TRACKER_SETTINGS_KEY_NAME, SettingValue.create((String)settingsString));
        this.configuredTimeTrackerSetting = null;
    }

    public static final String toJsonString(Object object) {
        try {
            return JSON_GENERATOR.createJsonObject(object).toString();
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error parsing object to string " + String.valueOf(object), e);
        }
    }

    public static final <T> T fromJsonString(String value, Class<T> resultClass) {
        try {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
            JSON_PARSER.parse((InputStream)new ByteArrayInputStream(value.getBytes()), (JsonHandler)jsonDefaultHandler);
            return (T)ObjectBuilder.createObject(resultClass, (JsonValue)jsonDefaultHandler.getJsonObject());
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error creating object from string : " + value, e);
        }
    }
}

