/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upgrade;

import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upgrade.CleanFavoriteApplications$AjcClosure1;

public class CleanFavoriteApplications
extends UpgradeProductPlugin {
    private static final Log log;
    private EntityManagerService entityManagerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CleanFavoriteApplications(InitParams initParams, EntityManagerService entityManagerService) {
        super(initParams);
        this.entityManagerService = entityManagerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        List<Object[]> duplicatedFavoriteAppsEntityList = this.getDuplicatedFavoriteAppsEntityList(entityManager);
        if (duplicatedFavoriteAppsEntityList.isEmpty()) {
            return;
        }
        log.info("Start upgrade of cleaning for favorite applications, {} favorite applications should be deleted", new Object[]{duplicatedFavoriteAppsEntityList.size()});
        HashSet uniqueUserNames = new HashSet();
        duplicatedFavoriteAppsEntityList.forEach(favoriteApplicationEntity -> uniqueUserNames.add((String)favoriteApplicationEntity[2]));
        log.info("{} favorite applications duplicated for {} users", new Object[]{duplicatedFavoriteAppsEntityList.size(), uniqueUserNames.size()});
        int favoriteApplicationCount = this.cleanFavoriteApps(entityManager, duplicatedFavoriteAppsEntityList);
        log.info("End upgrade : Deleted {} favorite applications done it took {} ms", new Object[]{favoriteApplicationCount, System.currentTimeMillis() - startupTime});
    }

    private List<Object[]> getDuplicatedFavoriteAppsEntityList(EntityManager entityManager) {
        String selectQuery = "SELECT * FROM AC_FAVORITE_APPLICATION favoriteApp WHERE (favoriteApp.APPLICATION_ID, favoriteApp.USER_NAME) IN (    SELECT favoriteApplication.APPLICATION_ID, favoriteApplication.USER_NAME     FROM AC_FAVORITE_APPLICATION favoriteApplication     GROUP BY favoriteApplication.APPLICATION_ID, favoriteApplication.USER_NAME     HAVING COUNT(*) > 1)";
        Query nativeQuery = entityManager.createNativeQuery(selectQuery);
        return nativeQuery.getResultList();
    }

    protected int cleanFavoriteApps(EntityManager entityManager, List<Object[]> duplicatedFavoriteApplicationsEntityList) {
        List<FavoriteApplicationEntity> duplicatedFavoriteAppsEntityList = this.toFavoriteAppsEntityList(duplicatedFavoriteApplicationsEntityList);
        ArrayList<FavoriteApplicationEntity> favoriteAppsEntityList = new ArrayList<FavoriteApplicationEntity>();
        int favoriteAppCount = 0;
        for (FavoriteApplicationEntity favoriteApplicationEntity : duplicatedFavoriteAppsEntityList) {
            FavoriteApplicationEntity favoriteAppEntityOfIdNull = new FavoriteApplicationEntity(Long.valueOf(0L), favoriteApplicationEntity.getApplication(), favoriteApplicationEntity.getUserName(), favoriteApplicationEntity.getOrder());
            if (favoriteAppsEntityList.contains(favoriteAppEntityOfIdNull)) {
                this.deleteFavoriteApplication(entityManager, favoriteApplicationEntity.getId());
                ++favoriteAppCount;
                continue;
            }
            favoriteAppsEntityList.add(favoriteAppEntityOfIdNull);
        }
        return favoriteAppCount;
    }

    List<FavoriteApplicationEntity> toFavoriteAppsEntityList(List<Object[]> objects) {
        ArrayList<FavoriteApplicationEntity> favoriteAppsEntityList = new ArrayList<FavoriteApplicationEntity>();
        objects.forEach(object -> {
            ApplicationEntity applicationEntity = new ApplicationEntity();
            applicationEntity.setId((Long)object[1]);
            favoriteAppsEntityList.add(new FavoriteApplicationEntity((Long)object[0], applicationEntity, (String)object[2], null));
        });
        return favoriteAppsEntityList;
    }

    @ExoTransactional
    protected void deleteFavoriteApplication(EntityManager entityManager, Long favoriteApplicationId) {
        EntityManager entityManager2 = entityManager;
        Long l = favoriteApplicationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)entityManager2, (Object)l);
        Object[] objectArray = new Object[]{this, entityManager2, l, joinPoint};
        CleanFavoriteApplications$AjcClosure1 cleanFavoriteApplications$AjcClosure1 = new CleanFavoriteApplications$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(cleanFavoriteApplications$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        CleanFavoriteApplications.ajc$preClinit();
        log = ExoLogger.getLogger((String)CleanFavoriteApplications.class.getName());
    }

    static final /* synthetic */ void deleteFavoriteApplication_aroundBody0(CleanFavoriteApplications ajc$this, EntityManager entityManager, Long favoriteApplicationId, JoinPoint joinPoint) {
        String deleteQuery = "DELETE FROM AC_FAVORITE_APPLICATION WHERE ID = " + favoriteApplicationId;
        Query query = entityManager.createNativeQuery(deleteQuery);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CleanFavoriteApplications.java", CleanFavoriteApplications.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteFavoriteApplication", "org.exoplatform.upgrade.CleanFavoriteApplications", "jakarta.persistence.EntityManager:java.lang.Long", "entityManager:favoriteApplicationId", "", "void"), 93);
    }
}

