/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.category.upgrade;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.upgrade.CleanAppRegistryCategoryUpgradePlugin;
import org.exoplatform.category.upgrade.CleanAppRegistryCategoryUpgradePluginTest$AjcClosure1;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.config.model.ApplicationType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.application-registry-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/application-registry-initializer-configuration.xml")})
public class CleanAppRegistryCategoryUpgradePluginTest
extends AbstractKernelTest {
    protected PortalContainer container;
    protected ApplicationRegistryService applicationRegistryService;
    protected EntityManagerService entityManagerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.applicationRegistryService = (ApplicationRegistryService)CommonsUtils.getService(ApplicationRegistryService.class);
        this.entityManagerService = (EntityManagerService)CommonsUtils.getService(EntityManagerService.class);
        this.begin();
    }

    @After
    public void tearDown() {
        this.end();
    }

    @Test
    @ExoTransactional
    public void testAppRegistryCategoryUpgradePlugin() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        CleanAppRegistryCategoryUpgradePluginTest$AjcClosure1 cleanAppRegistryCategoryUpgradePluginTest$AjcClosure1 = new CleanAppRegistryCategoryUpgradePluginTest$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(cleanAppRegistryCategoryUpgradePluginTest$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    private ApplicationCategory createAppCategory(String categoryName, String categoryDes) {
        ApplicationCategory category = new ApplicationCategory();
        category.setName(categoryName);
        category.setDisplayName(categoryName);
        category.setDescription(categoryDes);
        return category;
    }

    private Application createApplication(String appName, String contentId) {
        Application app = new Application();
        app.setContentId(contentId);
        app.setApplicationName(appName);
        app.setDisplayName(appName);
        app.setType(ApplicationType.PORTLET);
        return app;
    }

    static {
        CleanAppRegistryCategoryUpgradePluginTest.ajc$preClinit();
    }

    static /* synthetic */ void testAppRegistryCategoryUpgradePlugin_aroundBody0(CleanAppRegistryCategoryUpgradePluginTest ajc$this, JoinPoint joinPoint) {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        String toolsCategoryName = "Tools";
        String analyticsCategoryName = "Analytics";
        ApplicationCategory toolsCategory = ajc$this.createAppCategory(toolsCategoryName, "None");
        ApplicationCategory analytics = ajc$this.createAppCategory(analyticsCategoryName, "None");
        ajc$this.applicationRegistryService.save(toolsCategory);
        ajc$this.applicationRegistryService.save(analytics);
        Application IFramePortletApp = ajc$this.createApplication("IFramePortlet", "web/IFramePortlet");
        Application AnalyticsPortletApp = ajc$this.createApplication("AnalyticsPortlet", "analytics/AnalyticsPortlet");
        ajc$this.applicationRegistryService.save(toolsCategory, IFramePortletApp);
        ajc$this.applicationRegistryService.save(analytics, AnalyticsPortletApp);
        try {
            List apps = ajc$this.applicationRegistryService.getAllApplications();
            List cats = ajc$this.applicationRegistryService.getApplicationCategories();
            CleanAppRegistryCategoryUpgradePluginTest.assertFalse((boolean)apps.isEmpty());
            CleanAppRegistryCategoryUpgradePluginTest.assertFalse((boolean)cats.isEmpty());
            ApplicationCategory tools = ajc$this.applicationRegistryService.getApplicationCategory(toolsCategoryName);
            CleanAppRegistryCategoryUpgradePluginTest.assertNotNull((Object)tools);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((tools.getApplications().size() == 2 ? 1 : 0) != 0);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((boolean)tools.getApplications().stream().anyMatch(application -> application.getApplicationName().equals("IFramePortlet")));
            ApplicationCategory analyticsCategory = ajc$this.applicationRegistryService.getApplicationCategory(analyticsCategoryName);
            CleanAppRegistryCategoryUpgradePluginTest.assertNotNull((Object)analyticsCategory);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((analyticsCategory.getApplications().size() == 1 ? 1 : 0) != 0);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((boolean)analyticsCategory.getApplications().stream().anyMatch(application -> application.getApplicationName().equals("AnalyticsPortlet")));
        }
        catch (Exception e) {
            CleanAppRegistryCategoryUpgradePluginTest.fail();
        }
        CleanAppRegistryCategoryUpgradePlugin appRegistryCategoryUpgradePlugin = new CleanAppRegistryCategoryUpgradePlugin(ajc$this.container, ajc$this.entityManagerService, initParams);
        appRegistryCategoryUpgradePlugin.processUpgrade(null, null);
        try {
            List apps = ajc$this.applicationRegistryService.getAllApplications();
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((!apps.isEmpty() ? 1 : 0) != 0);
            List cats = ajc$this.applicationRegistryService.getApplicationCategories();
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((!cats.isEmpty() ? 1 : 0) != 0);
            ApplicationCategory tools = ajc$this.applicationRegistryService.getApplicationCategory(toolsCategoryName);
            CleanAppRegistryCategoryUpgradePluginTest.assertNotNull((Object)tools);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((tools.getApplications().size() == 1 ? 1 : 0) != 0);
            CleanAppRegistryCategoryUpgradePluginTest.assertTrue((boolean)((Application)tools.getApplications().get(0)).getApplicationName().equals("WhoIsOnLinePortlet"));
            ApplicationCategory analyticsCategory = ajc$this.applicationRegistryService.getApplicationCategory(analyticsCategoryName);
            CleanAppRegistryCategoryUpgradePluginTest.assertNull((Object)analyticsCategory);
        }
        catch (Exception e) {
            CleanAppRegistryCategoryUpgradePluginTest.fail();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CleanAppRegistryCategoryUpgradePluginTest.java", CleanAppRegistryCategoryUpgradePluginTest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testAppRegistryCategoryUpgradePlugin", "org.exoplatform.category.upgrade.CleanAppRegistryCategoryUpgradePluginTest", "", "", "java.lang.Exception", "void"), 56);
    }
}

