/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration.dlp;

import java.util.ArrayList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.dlp.AdminDlpQuarantinePageMigration;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdminDlpQuarantinePageMigrationTest {
    private static final String SITE_TYPE = PortalConfig.GROUP_TYPE;
    private static final String SITE_NAME = "/platform/administrators";
    private static final String DLP_QUARANTINE = "dlp-quarantine";
    protected PortalContainer container;
    protected PageService pageService;
    protected NavigationService navigationService;
    protected ModelDataStorage modelDataStorage;
    protected DataStorage dataStorage;
    protected Page dlpQuarantinePage;

    @Before
    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.pageService = (PageService)this.container.getComponentInstanceOfType(PageService.class);
        this.navigationService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
        this.modelDataStorage = (ModelDataStorage)this.container.getComponentInstanceOfType(ModelDataStorage.class);
        this.dataStorage = (DataStorage)this.container.getComponentInstanceOfType(DataStorage.class);
        this.begin();
        this.injectData();
    }

    @After
    public void tearDown() {
        this.purgeData();
        this.end();
    }

    @Test
    public void testAdminDlpQuarantinePageMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        NavigationContext navigationContext = this.navigationService.loadNavigation(SiteKey.group((String)SITE_NAME));
        NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        Page page = new Page(SITE_TYPE, SITE_NAME, DLP_QUARANTINE);
        Assert.assertNotNull((Object)navigationContext);
        Assert.assertNotNull((Object)node.get(DLP_QUARANTINE));
        Assert.assertNotNull((Object)this.pageService.loadPage(page.getPageKey()));
        AdminDlpQuarantinePageMigration adminDlpQuarantinePageMigration = new AdminDlpQuarantinePageMigration(initParams, this.navigationService, this.pageService);
        adminDlpQuarantinePageMigration.processUpgrade(null, null);
        node = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        Assert.assertEquals((Object)node.get(DLP_QUARANTINE), null);
        Assert.assertEquals((Object)this.pageService.loadPage(page.getPageKey()), null);
    }

    protected void injectData() throws Exception {
        PortalConfig portalConfig = this.dataStorage.getPortalConfig(SITE_TYPE, SITE_NAME);
        if (portalConfig == null) {
            portalConfig = new PortalConfig(SITE_TYPE, SITE_NAME);
            this.dataStorage.create(portalConfig);
        }
        this.dlpQuarantinePage = this.createPage(DLP_QUARANTINE, "contentId");
        this.navigationService.saveNavigation(new NavigationContext(new SiteKey(SiteType.GROUP, SITE_NAME), new NavigationState(Integer.valueOf(1))));
        NavigationContext navigationContext = this.navigationService.loadNavigation(SiteKey.group((String)SITE_NAME));
        NodeContext node = this.navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        NavigationState navigationState = new NavigationState(Integer.valueOf(navigationContext.getState().getPriority() + 1));
        NodeContext dlpNodeContext = node.add(Integer.valueOf(node.getIndex()), DLP_QUARANTINE);
        dlpNodeContext.setState(dlpNodeContext.getState().builder().pageRef(this.dlpQuarantinePage.getPageKey()).build());
        this.navigationService.saveNavigation(navigationContext);
        this.navigationService.saveNode(dlpNodeContext, null);
    }

    protected void purgeData() {
        this.pageService.destroyPage(this.dlpQuarantinePage.getPageKey());
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    private Page createPage(String pageName, String contentId) throws Exception {
        Page page = new Page(SITE_TYPE, SITE_NAME, pageName);
        page.setAccessPermissions(new String[]{"Everyone"});
        ArrayList<Application> children = new ArrayList<Application>();
        page.setChildren(children);
        Application app = Application.createPortletApplication();
        children.add(app);
        app.setState((ApplicationState)new TransientApplicationState(contentId, null));
        app.setTheme("theme");
        app.setTitle("title");
        app.setAccessPermissions(new String[]{"Everyone"});
        PageState pageState = Utils.toPageState((Page)page);
        this.pageService.savePage(new PageContext(page.getPageKey(), pageState));
        this.dataStorage.save(page);
        return page;
    }
}

