/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration.dlp;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.dlp.DlpFolderAndDriveMigration;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpFolderAndDriveMigrationTest {
    private static final MockedStatic<SessionProvider> SESSION_PROVIDER = Mockito.mockStatic(SessionProvider.class);
    @Mock
    RepositoryService repositoryService;
    @Mock
    ManageDriveService manageDriveService;
    @Mock
    ManageableRepository repository;
    @Mock
    SessionProvider sessionProvider;
    @Mock
    Session session;
    @Mock
    NodeIterator nodeIterator;
    @Mock
    SettingService settingService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        SESSION_PROVIDER.close();
    }

    @Test
    public void testDlpFolderAndDriveMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam newNode = new ValueParam();
        newNode.setName("new.nodePath");
        newNode.setValue("/Quarantine");
        ValueParam oldNode = new ValueParam();
        oldNode.setName("old.nodePath");
        oldNode.setValue("/Security");
        initParams.addParameter((Parameter)newNode);
        initParams.addParameter((Parameter)oldNode);
        DriveData driveQuarantine = (DriveData)Mockito.mock(DriveData.class);
        DriveData driveSecurity = (DriveData)Mockito.mock(DriveData.class);
        SESSION_PROVIDER.when(() -> SessionProvider.createSystemProvider()).thenReturn((Object)this.sessionProvider);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)this.session.itemExists((String)ArgumentMatchers.any())).thenReturn((Object)true);
        Node securityNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)((Node)this.session.getItem("/Security"))).thenReturn((Object)securityNode);
        Mockito.when((Object)securityNode.getNodes()).thenReturn((Object)this.nodeIterator);
        Mockito.when((Object)this.nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Node childSecurityNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.nodeIterator.nextNode()).thenReturn((Object)childSecurityNode);
        Mockito.when((Object)this.manageDriveService.getDriveByName("Quarantine")).thenReturn((Object)driveQuarantine);
        Assert.assertNotNull((Object)this.manageDriveService.getDriveByName("Quarantine"));
        DlpFolderAndDriveMigration dlpFolderAndDriveMigration = new DlpFolderAndDriveMigration(initParams, this.settingService, this.repositoryService, this.manageDriveService);
        dlpFolderAndDriveMigration.processUpgrade(null, null);
        Assert.assertEquals((long)2L, (long)dlpFolderAndDriveMigration.getNodesMovedCount());
    }
}

