/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.activities;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecms.upgrade.activities.TemplateParamsUpgradePlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.cache.CachedActivityStorage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TempalteParamsUpgradePluginTest {
    private PortalContainer container;
    private EntityManagerService entityManagerService;
    private ActivityManager activityManager;
    private CachedActivityStorage cachedActivityStorage;

    @Before
    public void setUp() {
        this.container = PortalContainer.getInstance();
        this.activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        this.entityManagerService = (EntityManagerService)CommonsUtils.getService(EntityManagerService.class);
        this.cachedActivityStorage = (CachedActivityStorage)CommonsUtils.getService(CachedActivityStorage.class);
        this.begin();
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    @After
    public void tearDown() {
        this.end();
    }

    @Test
    public void templateParamsUpgradePluginTest() {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam.setName("new.template.params.key");
        valueParam.setValue("WORKSPACE");
        initParams.addParameter((Parameter)valueParam);
        valueParam.setName("old.template.params.key");
        valueParam.setValue("WORKSPACE  ");
        initParams.addParameter((Parameter)valueParam);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        TemplateParamsUpgradePlugin templateParamsUpgradePlugin = new TemplateParamsUpgradePlugin(this.container, this.entityManagerService, initParams);
        ExoSocialActivityImpl activity1 = new ExoSocialActivityImpl();
        activity1.setType("MY_ACTIVITY");
        HashMap<String, String> templateParams1 = new HashMap<String, String>();
        templateParams1.put("WORKSPACE  ", "collaboration");
        activity1.setTemplateParams(templateParams1);
        activity1.setUserId("1");
        activity1.setTitle("ActivityWithWrongTemplateParamsKey");
        this.activityManager.saveActivityNoReturn(identity, (ExoSocialActivity)activity1);
        ExoSocialActivityImpl activity2 = new ExoSocialActivityImpl();
        activity2.setType("MY_ACTIVITY");
        HashMap<String, String> templateParams2 = new HashMap<String, String>();
        templateParams2.put("workspace", "collaboration");
        activity2.setTemplateParams(templateParams2);
        activity2.setUserId("1");
        activity2.setTitle("ActivityWithlowercaseTemplateParamsKey");
        this.activityManager.saveActivityNoReturn(identity, (ExoSocialActivity)activity2);
        templateParamsUpgradePlugin.processUpgrade(null, null);
        Assert.assertEquals((long)2L, (long)this.activityManager.getActivitiesByPoster(identity).getSize());
        Assert.assertEquals((long)1L, (long)templateParamsUpgradePlugin.getTemplatePramasUpdatedCount());
        this.cachedActivityStorage.clearOwnerCache(identity.getId());
        List exoSocialActivityList = this.activityManager.getActivitiesByPoster(identity).loadAsList(0, 2);
        Assert.assertTrue((boolean)((ExoSocialActivity)exoSocialActivityList.get(1)).getTemplateParams().containsKey("WORKSPACE"));
        Assert.assertTrue((!((ExoSocialActivity)exoSocialActivityList.get(1)).getTemplateParams().containsKey("WORKSPACE  ") ? 1 : 0) != 0);
    }

    protected void end() {
        RequestLifeCycle.end();
    }
}

