/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.jcr.upgrade.HideDefaultFoldersUpgradePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class HideFoldersUpgradePluginTest {
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private SessionProviderService sessionProviderService;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private SessionProvider sessionProvider;
    @Mock
    private SettingService settingService;
    @Mock
    private Session session;
    @Mock
    private Workspace wokspace;

    @Test
    public void testHideFoldersUpgrade() throws Exception {
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Node node = (Node)Mockito.mock(Node.class);
        Query query = (Query)Mockito.mock(Query.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)this.session.getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any(ManageableRepository.class))).thenReturn((Object)this.session);
        InitParams initParams = new InitParams();
        ((Session)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)0))).save();
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)this.session);
        Mockito.lenient().when((Object)this.session.getWorkspace()).thenReturn((Object)this.wokspace);
        Mockito.lenient().when((Object)this.wokspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.lenient().when((Object)node.getSession().getWorkspace().getQueryManager().createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)query);
        Mockito.lenient().when((Object)query.execute()).thenReturn((Object)queryResult);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.lenient().when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.lenient().when((Object)nodeIterator.getSize()).thenReturn((Object)3L);
        Mockito.lenient().when((Object)nodeIterator.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.lenient().when((Object)nodeIterator.nextNode()).thenReturn((Object)node);
        HideDefaultFoldersUpgradePlugin plugin = new HideDefaultFoldersUpgradePlugin(initParams, this.repositoryService, this.settingService, this.sessionProviderService);
        plugin.processUpgrade(null, null);
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)3))).save();
        ((SessionProvider)Mockito.verify((Object)this.sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
    }
}

