/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.migration.PortalConfigPermissionMigration;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.PermissionDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.services.cache.CacheService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class PortalConfigPermissionMigrationTest
extends AbstractKernelTest {
    protected PortalContainer container;
    protected NavigationService navigationService;
    protected LayoutService layoutService;
    protected CacheService cacheService;
    protected EntityManagerService entityManagerService;
    protected NavigationContext nav;

    @Before
    public void setUp() throws Exception {
        this.container = PortalContainer.getInstance();
        this.navigationService = (NavigationService)this.container.getComponentInstanceOfType(NavigationService.class);
        this.layoutService = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.cacheService = (CacheService)this.container.getComponentInstanceOfType(CacheService.class);
        this.begin();
        this.injectData();
    }

    @After
    public void tearDown() {
        this.purgeData();
        this.end();
    }

    protected void injectData() throws Exception {
        this.createSite(SiteType.GROUP, "/my_group_name");
        this.nav = this.navigationService.loadNavigation(SiteKey.group((String)"/my_group_name"));
    }

    protected void purgeData() {
        this.navigationService.destroyNavigation(this.nav);
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected void createSite(SiteType type, String siteName) throws Exception {
        ArrayList<String> accessPermission = new ArrayList<String>();
        accessPermission.add("@owner@");
        ContainerData container = new ContainerData(null, "testcontainer_" + siteName, "", "", "", "", "", "", "", "", "", "", null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        PortalData portal = new PortalData(null, siteName, type.getName(), null, null, null, accessPermission, "manager:@owner@", null, null, container, true, 8, 0L);
        this.layoutService.create(new PortalConfig(portal));
        NavigationContext navigation = new NavigationContext(type.key(siteName), new NavigationState(Integer.valueOf(1)));
        this.navigationService.saveNavigation(navigation);
    }

    @Test
    public void testSiteConfigMigration() {
        InitParams initParams = new InitParams();
        PortalConfigPermissionMigration portalConfigPermissionMigration = new PortalConfigPermissionMigration(this.container, this.entityManagerService, this.cacheService, initParams);
        portalConfigPermissionMigration.processUpgrade(null, null);
        this.end();
        this.begin();
        SiteDAO siteDAO = (SiteDAO)CommonsUtils.getService(SiteDAO.class);
        SiteEntity site = siteDAO.findByKey(new SiteKey(SiteType.GROUP, "/my_group_name"));
        PortalConfigPermissionMigrationTest.assertNotNull((Object)site);
        PermissionDAO permissionDAO = (PermissionDAO)CommonsUtils.getService(PermissionDAO.class);
        List accessPermissionEntityList = permissionDAO.getPermissions(SiteEntity.class.getName(), site.getId(), PermissionEntity.TYPE.ACCESS);
        List editPermission = permissionDAO.getPermissions(SiteEntity.class.getName(), site.getId(), PermissionEntity.TYPE.EDIT);
        PortalConfigPermissionMigrationTest.assertEquals((int)1, (int)accessPermissionEntityList.size());
        PortalConfigPermissionMigrationTest.assertEquals((String)"/my_group_name", (String)((PermissionEntity)accessPermissionEntityList.get(0)).getPermission());
        PortalConfigPermissionMigrationTest.assertEquals((int)1, (int)editPermission.size());
        PortalConfigPermissionMigrationTest.assertEquals((String)"manager:/my_group_name", (String)((PermissionEntity)editPermission.get(0)).getPermission());
    }
}

