/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.io.Serializable;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.PortalNavigationIconMigration;
import org.exoplatform.portal.jdbc.entity.NodeEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.mop.NodeTarget;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class PortalNavigationIconMigrationTest
extends AbstractKernelTest {
    InitParams initParams = new InitParams();
    private PortalContainer container;
    private EntityManagerService entityManagerService;
    private PortalNavigationIconMigration portalNavigationIconMigration;
    private SiteDAO siteDAO;
    private PageDAO pageDAO;
    private NodeDAO nodeDAO;

    @Before
    public void setUp() {
        this.container = this.getContainer();
        this.siteDAO = (SiteDAO)this.container.getComponentInstanceOfType(SiteDAO.class);
        this.pageDAO = (PageDAO)this.container.getComponentInstanceOfType(PageDAO.class);
        this.nodeDAO = (NodeDAO)this.container.getComponentInstanceOfType(NodeDAO.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.begin();
        ValueParam productGroupIdValueParam = new ValueParam();
        productGroupIdValueParam.setName("product.group.id");
        productGroupIdValueParam.setValue("org.exoplatform.platform");
        ValueParam portalNodeNamesValueParam = new ValueParam();
        portalNodeNamesValueParam.setName("portal.node.names");
        portalNodeNamesValueParam.setValue("external-stream");
        ValueParam portalNodeIconsValueParam = new ValueParam();
        portalNodeIconsValueParam.setName("portal.node.icons");
        portalNodeIconsValueParam.setValue("fas fa-user-lock");
        this.initParams.addParameter((Parameter)productGroupIdValueParam);
        this.initParams.addParameter((Parameter)portalNodeNamesValueParam);
        this.initParams.addParameter((Parameter)portalNodeIconsValueParam);
        this.portalNavigationIconMigration = new PortalNavigationIconMigration(this.entityManagerService, this.initParams);
    }

    @After
    public void tearDown() throws Exception {
        this.end();
    }

    @Test
    public void testPortalNavigationIconMigration() {
        SiteEntity siteEntity = new SiteEntity();
        siteEntity.setName("dw");
        siteEntity.setSiteType(SiteType.PORTAL);
        this.siteDAO.create((Object)siteEntity);
        siteEntity = this.siteDAO.findByType(SiteType.PORTAL).stream().filter(e -> e.getName().equals("dw")).toList().get(0);
        PortalNavigationIconMigrationTest.assertNotNull((Object)siteEntity);
        PageEntity pageEntity = new PageEntity();
        pageEntity.setName("stream");
        pageEntity.setOwner(siteEntity);
        pageEntity.setPageType(PageType.PAGE);
        this.pageDAO.create((Object)pageEntity);
        pageEntity = this.pageDAO.findAll().stream().filter(e -> e.getName().equals("stream")).toList().get(0);
        PortalNavigationIconMigrationTest.assertNotNull((Object)pageEntity);
        NodeEntity nodeEntity = new NodeEntity();
        nodeEntity.setName("external-stream");
        nodeEntity.setIcon(null);
        nodeEntity.setPage(pageEntity);
        nodeEntity.setTarget(NodeTarget.NEW_TAB);
        this.nodeDAO.create((Object)nodeEntity);
        nodeEntity = this.nodeDAO.findAllByPage(pageEntity.getId()).stream().filter(e -> e.getName().equals("external-stream")).toList().get(0);
        PortalNavigationIconMigrationTest.assertNotNull((Object)nodeEntity);
        this.restartTransaction();
        this.portalNavigationIconMigration.processUpgrade(null, null);
        PortalNavigationIconMigrationTest.assertEquals((int)1, (int)this.portalNavigationIconMigration.getMigratedPortalNodeIconsNodeIcons());
        nodeEntity = (NodeEntity)this.nodeDAO.find((Serializable)nodeEntity.getId());
        PortalNavigationIconMigrationTest.assertNotNull((Object)nodeEntity);
        PortalNavigationIconMigrationTest.assertNotNull((Object)nodeEntity.getIcon());
        PortalNavigationIconMigrationTest.assertEquals((String)"fas fa-user-lock", (String)nodeEntity.getIcon());
    }
}

